/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.mail;

import de.betoffice.mail.MailTask;
import de.betoffice.storage.user.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SendUserProfileChangeMailNotification {
    private static final Logger LOG = LoggerFactory.getLogger(SendUserProfileChangeMailNotification.class);
    private final String confirmMailAddressUrl;
    private final MailTask mailTask;

    public SendUserProfileChangeMailNotification(MailTask mailTask, @Value(value="${betoffice.mail.confirm.url}") String confirmMailAddressUrl) {
        this.mailTask = mailTask;
        this.confirmMailAddressUrl = confirmMailAddressUrl;
    }

    public User send(User user) {
        StringBuilder sb = new StringBuilder();
        sb.append("Hallo ").append(user.getNickname().value()).append("!").append(" Du m\u00f6chtest deine Mail Adresse \u00e4ndern? Dann bitte best\u00e4tige deine neue Mail-Adresse \u00fcber den folgenden Link: ").append(this.confirmMailAddressUrl).append("/").append(user.getChangeToken());
        try {
            user.incrementChangeSend();
            this.mailTask.send("betoffice@andre-winkler.de", user.getChangeEmail(), "Mail Adresse wurde ge\u00e4ndert", sb.toString());
        }
        catch (Exception ex) {
            LOG.error(String.format("Unable to send an email to %s", user.getChangeEmail()), (Throwable)ex);
        }
        return user;
    }
}

