/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.community.entity;

import de.betoffice.storage.AbstractStorageObject;
import de.betoffice.storage.community.entity.CommunityReference;
import de.betoffice.storage.season.entity.Group;
import de.betoffice.storage.season.entity.Season;
import de.betoffice.storage.user.entity.User;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="bo_community")
public class Community
extends AbstractStorageObject {
    private static final long serialVersionUID = -7239278975374588294L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Embedded
    private CommunityReference reference;
    @NotNull
    @Column(name="bo_name")
    private String name;
    @NotNull
    @Column(name="bo_year")
    private String year;
    @ManyToOne
    @JoinColumn(name="bo_user_ref")
    private User communityManager;
    @ManyToOne
    @JoinColumn(name="bo_season_ref")
    private Season season;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinTable(name="bo_community_user", joinColumns={@JoinColumn(name="bo_community_ref")}, inverseJoinColumns={@JoinColumn(name="bo_user_ref")})
    private Set<User> users = new HashSet<User>();

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public CommunityReference getReference() {
        return this.reference;
    }

    public void setReference(CommunityReference reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public User getCommunityManager() {
        return this.communityManager;
    }

    public void setCommunityManager(User user) {
        this.communityManager = user;
    }

    public Season getSeason() {
        return this.season;
    }

    public void setSeason(Season season) {
        this.season = season;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public void addMember(User user) {
        this.users.add(user);
    }

    public void removeMember(User user) {
        this.users.remove(user);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Group)) {
            return false;
        }
        Community community = (Community)object;
        return community.getId().equals(this.getId());
    }

    public int hashCode() {
        return 37;
    }
}

