/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.group.dao;

import de.betoffice.storage.group.GroupTypeDao;
import de.betoffice.storage.group.entity.GroupType;
import de.betoffice.storage.hibernate.AbstractCommonDao;
import de.betoffice.storage.season.entity.Season;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;

@Repository(value="groupTypeDao")
public class GroupTypeDaoHibernate
extends AbstractCommonDao<GroupType>
implements GroupTypeDao {
    private static final String QUERY_GROUPTYPE_BY_NAME = "from " + GroupType.class.getName() + " groupType where groupType.name = :groupTypeName order by groupType.name";
    private static final String QUERY_GROUPTYPES_BY_SEASON = AbstractCommonDao.loadQuery(GroupTypeDaoHibernate.class, "hql_grouptype_season.sql");

    public GroupTypeDaoHibernate() {
        super(GroupType.class);
    }

    @Override
    public List<GroupType> findAll() {
        return this.getEntityManager().createQuery("from GroupType order by name", GroupType.class).getResultList();
    }

    @Override
    public Optional<GroupType> findByName(String name) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_GROUPTYPE_BY_NAME, GroupType.class).setParameter("groupTypeName", (Object)name);
        return GroupTypeDaoHibernate.singleResult(query);
    }

    @Override
    public List<GroupType> findBySeason(Season season) {
        return this.getEntityManager().createQuery(QUERY_GROUPTYPES_BY_SEASON, GroupType.class).setParameter("season_id", (Object)season.getId()).getResultList();
    }
}

