/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.hibernate;

import de.betoffice.storage.community.CommonDao;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCommonDao<T>
implements CommonDao<T> {
    private final Class<T> t;
    private EntityManager entityManager;

    @Autowired
    public void setEntityManager(EntityManager _entityManager) {
        this.entityManager = _entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected AbstractCommonDao(Class<T> _t) {
        this.t = _t;
    }

    @Override
    public T findById(long id) {
        return (T)this.getEntityManager().find(this.t, (Object)id);
    }

    @Override
    public void delete(T t) {
        this.getEntityManager().remove(t);
    }

    @Override
    public T persist(T t) {
        this.getEntityManager().persist(t);
        return t;
    }

    @Override
    public void update(T t) {
        this.getEntityManager().merge(t);
    }

    @Override
    public void refresh(T t) {
        this.getEntityManager().refresh(t);
    }

    protected T first(List<T> objects) {
        if (objects.size() == 0) {
            return null;
        }
        return objects.get(0);
    }

    public static final String loadQuery(Class<?> clazz, String query) {
        try {
            InputStream resourceAsStream = clazz.getResourceAsStream(query);
            if (resourceAsStream == null) {
                throw new RuntimeException("Could not find query resource: " + query + " for class: " + clazz.getName());
            }
            return IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> Optional<T> singleResult(TypedQuery<T> query) {
        Optional<Object> optionalResult;
        try {
            Object result = query.getSingleResult();
            optionalResult = Optional.of(result);
        }
        catch (NoResultException ex) {
            optionalResult = Optional.empty();
        }
        return optionalResult;
    }

    public static <T> Optional<T> singleResult(List<T> list) {
        Optional optionalResult = Optional.empty();
        if (list.size() > 0) {
            optionalResult = Optional.of(list.get(0));
        }
        return optionalResult;
    }
}

