/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.season.dao;

import de.betoffice.storage.hibernate.AbstractCommonDao;
import de.betoffice.storage.season.GameTippDao;
import de.betoffice.storage.season.entity.Game;
import de.betoffice.storage.tip.GameTipp;
import de.betoffice.storage.user.entity.User;
import java.util.List;
import java.util.Optional;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository(value="gameTippDao")
public class GameTippDaoHibernate
extends AbstractCommonDao<GameTipp>
implements GameTippDao {
    private static final String QUERY_GAMETIPP_BY_MATCH = "from     GameTipp gametipp    join fetch gametipp.user     join fetch gametipp.game where     gametipp.game.id = :gameId";
    private static final String QUERY_GAMETIPP_BY_MATCH_AND_USER = "from     GameTipp gametipp    join fetch gametipp.user     join fetch gametipp.game where     gametipp.game.id = :gameId     and gametipp.user.id = :userId";
    private static final String QUERY_ROUND_AND_TIPPS_BY_USER_AND_ROUND = "select     tipp from     GameTipp as tipp     join fetch tipp.game game     join fetch game.homeTeam     join fetch game.guestTeam     join fetch game.group     join fetch game.gameList round     join fetch tipp.user user where     round.id = :roundId     and user.id = :userId";
    private static final String QUERY_ROUND_AND_TIPPS_BY_ROUND = "select     tipp from     GameTipp as tipp     join fetch tipp.game game     join fetch game.homeTeam     join fetch game.guestTeam     join fetch game.group     join fetch game.gameList round     join fetch tipp.user user where     round.id = :roundId";

    public GameTippDaoHibernate() {
        super(GameTipp.class);
    }

    @Override
    public List<GameTipp> find(Game match) {
        List tipps = this.getEntityManager().createQuery(QUERY_GAMETIPP_BY_MATCH, GameTipp.class).setParameter("gameId", (Object)match.getId()).getResultList();
        return tipps;
    }

    @Override
    public Optional<GameTipp> find(Game game, User user) {
        Optional tipp = ((Session)this.getEntityManager().unwrap(Session.class)).createQuery(QUERY_GAMETIPP_BY_MATCH_AND_USER, GameTipp.class).setParameter("gameId", (Object)game.getId()).setParameter("userId", (Object)user.getId()).uniqueResultOptional();
        return tipp;
    }

    @Override
    public List<GameTipp> find(long roundId, long userId) {
        List tipps = this.getEntityManager().createQuery(QUERY_ROUND_AND_TIPPS_BY_USER_AND_ROUND, GameTipp.class).setParameter("roundId", (Object)roundId).setParameter("userId", (Object)userId).getResultList();
        return tipps;
    }

    @Override
    public List<GameTipp> find(long roundId) {
        List tipps = this.getEntityManager().createQuery(QUERY_ROUND_AND_TIPPS_BY_ROUND, GameTipp.class).setParameter("roundId", (Object)roundId).getResultList();
        return tipps;
    }
}

