/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.season.dao;

import de.betoffice.storage.hibernate.AbstractCommonDao;
import de.betoffice.storage.season.PlayerDao;
import de.betoffice.storage.season.entity.Player;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;

@Repository(value="playerDao")
public class PlayerDaoHibernate
extends AbstractCommonDao<Player>
implements PlayerDao {
    public PlayerDaoHibernate() {
        super(Player.class);
    }

    @Override
    public List<Player> findAll() {
        return this.getEntityManager().createQuery("from Player as player order by player.name", Player.class).getResultList();
    }

    @Override
    public Optional<Player> findByOpenligaid(long openligaid) {
        TypedQuery query = this.getEntityManager().createQuery("from Player as player where player.openligaid = :openligaid", Player.class).setParameter("openligaid", (Object)openligaid);
        return PlayerDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<Player> findAllGoalsOfPlayer(long id) {
        TypedQuery query = this.getEntityManager().createQuery("from Player as player left join fetch player.goals where player.id = :id", Player.class).setParameter("id", (Object)id);
        return PlayerDaoHibernate.singleResult(query);
    }
}

