/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.season.entity;

import de.betoffice.storage.AbstractStorageObject;
import de.betoffice.storage.season.entity.Game;
import de.betoffice.storage.season.entity.Group;
import de.betoffice.storage.season.entity.Season;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TimeZoneStorageType;

@Entity
@Table(name="bo_gamelist")
public class GameList
extends AbstractStorageObject
implements Comparable<GameList> {
    private static final long serialVersionUID = -3629753274439214154L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="bo_index")
    private int index;
    @Column(name="bo_openligaid")
    private Long openligaid;
    @Column(name="bo_datetime")
    @TimeZoneStorage(value=TimeZoneStorageType.NORMALIZE)
    private ZonedDateTime dateTime;
    @ManyToOne
    @JoinColumn(name="bo_season_ref")
    private Season season;
    @ManyToOne
    @JoinColumn(name="bo_group_ref")
    private Group group;
    @OneToMany(mappedBy="gameList", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderColumn(name="bo_index")
    private List<Game> gameList = new ArrayList<Game>();

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    protected List<Game> getGameList() {
        return this.gameList;
    }

    protected void setGameList(List<Game> value) {
        Objects.requireNonNull(value);
        this.gameList = value;
    }

    public void addGame(Game value) {
        Objects.requireNonNull(value);
        if (this.gameList.contains(value)) {
            throw new IllegalArgumentException("The game '" + String.valueOf(value) + "' already exists!");
        }
        this.gameList.add(value);
        value.setIndex(this.gameList.indexOf(value));
        value.setGameList(this);
    }

    public void removeAllGame() {
        ArrayList<Game> tmp = new ArrayList<Game>(this.getGameList());
        for (Game game : tmp) {
            this.removeGame(game);
        }
    }

    public void removeGame(Game value) {
        Objects.requireNonNull(value);
        if (!this.gameList.contains(value)) {
            throw new IllegalArgumentException(String.valueOf(value) + " nicht vorhanden!");
        }
        this.gameList.remove(value);
        value.setGameList(null);
    }

    public List<Game> toList(Group _group) {
        return this.toList((Game game) -> game.getGroup().equals(_group));
    }

    public List<Game> toList(Predicate<Game> filter) {
        return this.gameList.stream().filter(filter).toList();
    }

    public List<Game> unmodifiableList() {
        return Collections.unmodifiableList(this.gameList);
    }

    public Game get(int _index) {
        return this.gameList.get(_index);
    }

    public Game getById(long id) {
        for (Game game : this.gameList) {
            if (game.getId() != id) continue;
            return game;
        }
        return null;
    }

    public int size() {
        return this.gameList.size();
    }

    public boolean isEmpty() {
        return this.gameList.isEmpty();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value is smaller than zero.");
        }
        this.index = value;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(ZonedDateTime _dateTime) {
        this.dateTime = _dateTime;
    }

    public Season getSeason() {
        return this.season;
    }

    public void setSeason(Season value) {
        this.season = value;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group value) {
        this.group = value;
    }

    public Long getOpenligaid() {
        return this.openligaid;
    }

    public void setOpenligaid(Long value) {
        this.openligaid = value;
    }

    public boolean isBefore(GameList _gameList) {
        return this.getIndex() < _gameList.getIndex();
    }

    public boolean isAfter(GameList gd) {
        return this.getIndex() > gd.getIndex();
    }

    public LocalDate findBestRoundDate() {
        ArrayList<ZonedDateTime> matchDates = new ArrayList<ZonedDateTime>();
        for (Game match : this.gameList) {
            matchDates.add(match.getDateTime());
        }
        return GameList.findBestDate(matchDates);
    }

    public static LocalDate findBestDate(List<ZonedDateTime> matchDates) {
        if (matchDates.isEmpty()) {
            return null;
        }
        HashMap<LocalDate, Integer> dates = new HashMap<LocalDate, Integer>();
        for (ZonedDateTime date : matchDates) {
            if (!dates.containsKey(date.toLocalDate())) {
                dates.put(date.toLocalDate(), 0);
            }
            Integer value = (Integer)dates.get(date.toLocalDate());
            dates.put(date.toLocalDate(), value + 1);
        }
        Map.Entry bestDate = null;
        Set values = dates.entrySet();
        for (Map.Entry dateCount : values) {
            if (bestDate == null) {
                bestDate = dateCount;
                continue;
            }
            if ((Integer)dateCount.getValue() <= (Integer)bestDate.getValue()) continue;
            bestDate = dateCount;
        }
        return (LocalDate)bestDate.getKey();
    }

    public boolean isValid() {
        if (this.dateTime == null) {
            return false;
        }
        return this.group != null;
    }

    @Override
    public int compareTo(GameList _round) {
        if (this.getIndex() < _round.getIndex()) {
            return -1;
        }
        if (this.getIndex() > _round.getIndex()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + "# ID: " + this.getId();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GameList)) {
            return false;
        }
        GameList other = (GameList)object;
        return other.getId().equals(this.getId());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getId().hashCode();
        return result;
    }
}

