/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.team.dao;

import de.betoffice.storage.group.entity.GroupType;
import de.betoffice.storage.hibernate.AbstractCommonDao;
import de.betoffice.storage.season.entity.Season;
import de.betoffice.storage.team.TeamDao;
import de.betoffice.storage.team.TeamType;
import de.betoffice.storage.team.entity.Team;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Optional;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository(value="teamDao")
public class TeamDaoHibernate
extends AbstractCommonDao<Team>
implements TeamDao {
    private static final String QUERY_TEAMS_BY_SEASON_AND_GROUPTYPE = AbstractCommonDao.loadQuery(TeamDaoHibernate.class, "query_teams_by_season_and_grouptype.sql");
    public static final String QUERY_TEAM_BY_NAME = "select team from Team as team where team.name = :teamName";
    public static final String QUERY_TEAM_BY_TYPE = "select team from Team as team where team.teamType = :teamType order by team.name";
    public static final String QUERY_TEAM_BY_OPENLIGAID = "select team from Team as team where team.openligaid = :openligaid";

    public TeamDaoHibernate() {
        super(Team.class);
    }

    @Override
    public List<Team> findAll() {
        return this.getEntityManager().createQuery("select team from Team as team order by team.name", Team.class).getResultList();
    }

    @Override
    public List<Team> findTeams(TeamType teamType) {
        return this.getEntityManager().createQuery(QUERY_TEAM_BY_TYPE, Team.class).setParameter("teamType", (Object)teamType).getResultList();
    }

    @Override
    public List<Team> findTeams(Optional<TeamType> teamType, String filter) {
        String query = "SELECT\n    team\nFROM\n    Team as team\nWHERE\n    (\n        :filter IS NULL\n        OR LOWER(team.name) LIKE '%' || :filter || '%'\n    )\n    AND\n    (\n        :teamType IS NULL OR team.teamType = :teamType\n    )\nORDER BY\n    team.name\n";
        return this.getEntityManager().createQuery("SELECT\n    team\nFROM\n    Team as team\nWHERE\n    (\n        :filter IS NULL\n        OR LOWER(team.name) LIKE '%' || :filter || '%'\n    )\n    AND\n    (\n        :teamType IS NULL OR team.teamType = :teamType\n    )\nORDER BY\n    team.name\n", Team.class).setParameter("teamType", teamType.orElse(null)).setParameter("filter", (Object)filter).getResultList();
    }

    @Override
    public Optional<Team> findByName(String name) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_TEAM_BY_NAME, Team.class).setParameter("teamName", (Object)name);
        return TeamDaoHibernate.singleResult(query);
    }

    @Override
    public List<Team> findTeamsBySeasonAndGroup(Season season, GroupType groupType) {
        List teams = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_TEAMS_BY_SEASON_AND_GROUPTYPE, Team.class).setParameter("season_id", (Object)season.getId()).setParameter("grouptype_id", (Object)groupType.getId()).list();
        return teams;
    }

    @Override
    public Optional<Team> findByOpenligaid(long openligaid) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_TEAM_BY_OPENLIGAID, Team.class).setParameter("openligaid", (Object)openligaid);
        return TeamDaoHibernate.singleResult(query);
    }
}

