/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.tip;

import de.betoffice.storage.user.UserResult;
import de.betoffice.util.LoggerFactory;
import java.util.Comparator;
import org.slf4j.Logger;

public final class UserPointsComparator
implements Comparator<UserResult> {
    private final Logger log = LoggerFactory.make();

    @Override
    public int compare(UserResult u1, UserResult u2) {
        int retcode = 0;
        if (u1.getPoints() > u2.getPoints()) {
            retcode = -1;
        } else if (u1.getPoints() < u2.getPoints()) {
            retcode = 1;
        } else if (u1.getPoints() == u2.getPoints()) {
            if (u1.getUserWin() > u2.getUserWin()) {
                retcode = -1;
            } else if (u1.getUserWin() < u2.getUserWin()) {
                retcode = 1;
            } else if (u1.getUserWin() == u2.getUserWin()) {
                retcode = u1.getUser().getNickname().toLowerCase().compareTo(u2.getUser().getNickname().toLowerCase());
            } else {
                throw new IllegalStateException();
            }
        }
        if (this.log.isDebugEnabled()) {
            if (retcode < 0) {
                this.log.debug("{} > {}", (Object)u1.getUser().getNickname(), (Object)u2.getUser().getNickname());
            } else if (retcode > 0) {
                this.log.debug("{} > {}", (Object)u2.getUser().getNickname(), (Object)u1.getUser().getNickname());
            } else {
                this.log.debug("{} == {}", (Object)u1.getUser().getNickname(), (Object)u2.getUser().getNickname());
            }
        }
        return retcode;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }
}

