/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.service;

import de.betoffice.service.AuthService;
import de.betoffice.service.SecurityToken;
import de.betoffice.storage.session.SessionDao;
import de.betoffice.storage.session.entity.Session;
import de.betoffice.storage.time.DateTimeProvider;
import de.betoffice.storage.user.RoleType;
import de.betoffice.storage.user.UserDao;
import de.betoffice.storage.user.entity.Nickname;
import de.betoffice.storage.user.entity.User;
import de.betoffice.util.LoggerFactory;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="authService")
@Transactional(readOnly=true)
public class DefaultAuthService
implements AuthService {
    private final Logger log = LoggerFactory.make();
    @Autowired
    private UserDao userDao;
    @Autowired
    private SessionDao sessionDao;
    @Autowired
    private DateTimeProvider dateTimeProvider;

    @Override
    @Transactional
    public SecurityToken login(Nickname name, String password, String sessionId, String address, String browserId) {
        Optional<User> user = this.userDao.findByNickname(name);
        SecurityToken securityToken = null;
        if (user.isPresent() && user.get().comparePwd(password)) {
            User presentUser = user.get();
            ArrayList<RoleType> roleTypes = new ArrayList<RoleType>();
            if (presentUser.isAdmin()) {
                roleTypes.add(RoleType.ADMIN);
            }
            if (!presentUser.isExcluded()) {
                roleTypes.add(RoleType.TIPPER);
            }
            ZonedDateTime now = this.dateTimeProvider.currentDateTime();
            securityToken = new SecurityToken(sessionId, presentUser, roleTypes, now);
            Session session = new Session();
            session.setBrowser(browserId);
            session.setFailedLogins(0);
            session.setLogin(now);
            session.setLogout(null);
            session.setNickname(name.getNickname());
            session.setRemoteAddress(address);
            session.setToken(securityToken.getToken());
            session.setUser(user.get());
            this.sessionDao.persist(session);
        }
        return securityToken;
    }

    @Override
    public Optional<SecurityToken> findTokenByNickname(Nickname nickname) {
        return this.findTokenByNickname(nickname);
    }

    @Override
    @Transactional
    public void logout(String securityToken) {
        List<Session> sessions = this.sessionDao.findBySessionId(securityToken);
        if (sessions.isEmpty()) {
            this.log.warn("Trying to logout with an invalid securityToken=[{}]", (Object)securityToken);
        } else {
            for (Session session : sessions) {
                session.setLogout(this.dateTimeProvider.currentDateTime());
                this.sessionDao.persist(session);
            }
        }
    }

    @Override
    public Optional<Session> validateSession(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            this.log.warn("There is no token to validate: token=[{}]", (Object)token);
            return Optional.empty();
        }
        List<Session> sessions = this.sessionDao.findBySessionId(token);
        if (sessions.isEmpty()) {
            this.log.warn("Tried to validate the session with an invalid securityToken=[{}]", (Object)token);
            return Optional.empty();
        }
        Session session = sessions.get(0);
        session.getUser().getNickname();
        return Optional.of(session);
    }

    @Override
    public Optional<User> findByNickname(Nickname nickname) {
        return this.userDao.findByNickname(nickname);
    }

    @Override
    public boolean isAdminSession(String token) {
        return this.validateSession(token).map(s -> s.getUser().getRoleTypes().contains((Object)RoleType.ADMIN)).orElse(false);
    }
}

