/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.service;

import de.betoffice.service.CommunityCalculatorService;
import de.betoffice.storage.community.CommunityDao;
import de.betoffice.storage.community.CommunityRankingDao;
import de.betoffice.storage.community.entity.Community;
import de.betoffice.storage.community.entity.CommunityReference;
import de.betoffice.storage.season.SeasonRange;
import de.betoffice.storage.season.entity.GameList;
import de.betoffice.storage.user.UserResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="communitySeasonService")
public class DefaultCommunityCalculatorService
implements CommunityCalculatorService {
    @Autowired
    private CommunityDao communityDao;
    @Autowired
    private CommunityRankingDao communityRankingDao;

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateRanking(CommunityReference communityReference, GameList round) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        return this.communityRankingDao.calculateUserRanking(community, round);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateRanking(CommunityReference communityReference) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        return this.communityRankingDao.calculateUserRanking(community);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateRanking(CommunityReference communityReference, SeasonRange seasonRange) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        return this.communityRankingDao.calculateUserRanking(community, seasonRange);
    }
}

