/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.service;

import de.betoffice.service.AbstractManagerService;
import de.betoffice.service.TippService;
import de.betoffice.storage.exception.StorageObjectNotFoundException;
import de.betoffice.storage.exception.StorageRuntimeException;
import de.betoffice.storage.season.GameTippDao;
import de.betoffice.storage.season.MatchDao;
import de.betoffice.storage.season.RoundDao;
import de.betoffice.storage.season.entity.Game;
import de.betoffice.storage.season.entity.GameList;
import de.betoffice.storage.season.entity.GameResult;
import de.betoffice.storage.time.DateTimeProvider;
import de.betoffice.storage.tip.GameTipp;
import de.betoffice.storage.tip.TippDto;
import de.betoffice.storage.tip.TippStatusType;
import de.betoffice.storage.tip.TotoResult;
import de.betoffice.storage.tip.UserResultOfDay;
import de.betoffice.storage.user.UserDao;
import de.betoffice.storage.user.entity.Nickname;
import de.betoffice.storage.user.entity.User;
import de.betoffice.util.LoggerFactory;
import de.betoffice.validation.ValidationException;
import de.betoffice.validation.ValidationMessage;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tippService")
@Transactional(readOnly=true)
public class DefaultTippService
extends AbstractManagerService
implements TippService {
    private final Logger log = LoggerFactory.make();
    @Autowired
    private UserDao userDao;
    @Autowired
    private RoundDao roundDao;
    @Autowired
    private MatchDao matchDao;
    @Autowired
    private GameTippDao gameTippDao;
    @Autowired
    private DateTimeProvider datetimeProvider;

    @Override
    @Transactional
    public GameTipp createOrUpdateTipp(String token, Game match, User user, GameResult tipp, TippStatusType status) {
        GameList round = this.roundDao.findRoundByGame(match).orElseThrow();
        return this.createOrUpdateTipp(token, round, match, user, tipp, status);
    }

    private GameTipp createOrUpdateTipp(String token, GameList round, Game game, User user, GameResult tipp, TippStatusType status) {
        Date now = Date.from(this.datetimeProvider.currentDateTime().toInstant());
        Optional<GameTipp> gameTipp = this.gameTippDao.find(game, user);
        if (gameTipp.isPresent()) {
            GameTipp updateGameTipp = gameTipp.get();
            updateGameTipp.setToken(token);
            updateGameTipp.setLastUpdateTime(now);
            updateGameTipp.setUser(user);
            updateGameTipp.setTipp(tipp, status);
            return this.gameTippDao.persist(updateGameTipp);
        }
        GameTipp newGameTipp = new GameTipp();
        newGameTipp.setToken(token);
        newGameTipp.setCreationTime(now);
        newGameTipp.setLastUpdateTime(now);
        newGameTipp.setUser(user);
        newGameTipp.setGame(game);
        newGameTipp.setTipp(tipp, status);
        return this.gameTippDao.persist(newGameTipp);
    }

    @Override
    @Transactional
    public List<GameTipp> createOrUpdateTipp(String token, GameList round, User user, List<GameResult> tipps, TippStatusType status) {
        ArrayList<GameTipp> result = new ArrayList<GameTipp>();
        for (int i = 0; i < round.size(); ++i) {
            result.add(this.createOrUpdateTipp(token, round.get(i), user, tipps.get(i), status));
        }
        return result;
    }

    private static ValidationMessage unknwonUser(String unknownUser) {
        return ValidationMessage.error(ValidationMessage.MessageType.USER_NOT_FOUND, unknownUser);
    }

    private static ValidationMessage unknwonRoundId(long roundId) {
        return ValidationMessage.error(ValidationMessage.MessageType.ROUND_ID_NOT_FOUND, roundId);
    }

    private static ValidationException newException(ValidationMessage message) {
        return new ValidationException(List.of(message));
    }

    private static Optional<GameTipp> findTipp(Game game, List<GameTipp> tipps) {
        return tipps.stream().filter(t -> t.getGame().equals(game)).findFirst();
    }

    @Override
    @Transactional
    public List<GameTipp> validateKickOffTimeAndAddTipp(TippDto tippDto) {
        User user = this.userDao.findByNickname(Nickname.of(tippDto.getNickname())).orElseThrow(() -> DefaultTippService.newException(DefaultTippService.unknwonUser(tippDto.getNickname())));
        GameList gameList = (GameList)this.roundDao.findById(tippDto.getRoundId());
        if (gameList == null) {
            throw DefaultTippService.newException(DefaultTippService.unknwonRoundId(tippDto.getRoundId()));
        }
        List<GameTipp> predefinedTipps = this.gameTippDao.find(gameList, user);
        for (TippDto.GameTippDto gameTippDto : tippDto.getGameTipps()) {
            Game game = (Game)this.matchDao.findById(gameTippDto.getGameId());
            if (!this.isSubmitTimeBeforeGameTime(tippDto, game)) continue;
            Optional<GameTipp> predefinedTipp = DefaultTippService.findTipp(game, predefinedTipps);
            if (predefinedTipp.isPresent()) {
                GameTipp persistedTipp = predefinedTipp.get();
                persistedTipp.setLastUpdateTime(Date.from(tippDto.getSubmitTime().toInstant()));
                persistedTipp.setToken(tippDto.getToken());
                persistedTipp.setTipp(GameResult.of(gameTippDto.getHomeGoals(), gameTippDto.getGuestGoals()), TippStatusType.USER);
                this.gameTippDao.update(persistedTipp);
                continue;
            }
            GameTipp gameTipp = PartiallyCompleteTippDto.toGameTipp(PartiallyCompleteTippDto.of(user, game, tippDto.getToken(), tippDto.getSubmitTime(), gameTippDto));
            this.gameTippDao.persist(gameTipp);
        }
        return this.gameTippDao.find(gameList, user);
    }

    private boolean isSubmitTimeBeforeGameTime(TippDto tipp, Game game) {
        return game.getDateTime() == null || tipp.getSubmitTime().isBefore(game.getDateTime());
    }

    @Override
    public List<GameTipp> findTipps(Game match) {
        return this.gameTippDao.find(match);
    }

    @Override
    public Optional<GameTipp> findTipp(Game game, User user) {
        return this.gameTippDao.find(game, user);
    }

    @Override
    public List<GameTipp> findTipps(long roundId, long userId) {
        return this.gameTippDao.find(roundId, userId);
    }

    @Override
    public List<GameTipp> findTipps(long roundId) {
        return this.gameTippDao.find(roundId);
    }

    @Override
    public Optional<GameList> findNextTippRound(ZonedDateTime date) {
        return this.roundDao.findNextTippRound(date).flatMap(i -> Optional.of((GameList)this.roundDao.findById((long)i)));
    }

    @Override
    public Optional<GameList> findNextTippRound(long seasonId, ZonedDateTime date) {
        return this.roundDao.findNextTippRound(seasonId, date).flatMap(i -> Optional.of((GameList)this.roundDao.findById((long)i)));
    }

    @Override
    public Optional<GameList> findPreviousTippRound(long seasonId, ZonedDateTime date) {
        return this.roundDao.findLastTippRound(seasonId, date).flatMap(i -> Optional.of((GameList)this.roundDao.findById((long)i)));
    }

    @Override
    public UserResultOfDay getUserPoints(GameList round, User user) {
        UserResultOfDay urod = new UserResultOfDay();
        List<GameTipp> tippsByRoundAndUser = this.findTipps(round, user);
        urod.setUser(user);
        for (GameTipp gameTipp : tippsByRoundAndUser) {
            if (!gameTipp.getGame().isPlayed()) continue;
            try {
                if (urod.getStatus() != null && !gameTipp.getStatus().equals((Object)urod.getStatus())) {
                    this.log.error("Der Tipp " + String.valueOf(gameTipp) + " ist fehlerhaft!");
                    throw new StorageRuntimeException("Ein Tipp wurde automatisch generiert. Ein anderer Tipp wurde per Teilnehmer generiert. Dieser Zustand sollte nicht auftreten!");
                }
                urod.setStatus(gameTipp.getStatus());
                urod.setTipps(urod.getTipps() + 1);
                if (gameTipp.getTotoResult() == TotoResult.EQUAL) {
                    urod.setWin(urod.getWin() + 1);
                    continue;
                }
                if (gameTipp.getTotoResult() != TotoResult.TOTO) continue;
                urod.setToto(urod.getToto() + 1);
            }
            catch (StorageObjectNotFoundException ex) {
                this.log.info("Kein Tipp f\u00fcr game: " + String.valueOf(gameTipp.getGame()) + " vorhanden");
            }
        }
        return urod;
    }

    private static class PartiallyCompleteTippDto {
        private final User user;
        private final Game game;
        private final String token;
        private final ZonedDateTime submitTime;
        private final TippDto.GameTippDto tippDto;

        private PartiallyCompleteTippDto(User user, Game game, String token, ZonedDateTime submitTime, TippDto.GameTippDto gameTippDto) {
            this.user = user;
            this.game = game;
            this.token = token;
            this.submitTime = submitTime;
            this.tippDto = gameTippDto;
        }

        public User getUser() {
            return this.user;
        }

        public Game getGame() {
            return this.game;
        }

        public String getToken() {
            return this.token;
        }

        public ZonedDateTime getSubmitTime() {
            return this.submitTime;
        }

        public TippDto.GameTippDto getTippDto() {
            return this.tippDto;
        }

        public static PartiallyCompleteTippDto of(User user, Game game, String token, ZonedDateTime submitTime, TippDto.GameTippDto gameTipp) {
            return new PartiallyCompleteTippDto(user, game, token, submitTime, gameTipp);
        }

        public static GameTipp toGameTipp(PartiallyCompleteTippDto tippDto) {
            Date submitTime = Date.from(tippDto.getSubmitTime().toInstant());
            GameTipp gameTipp = new GameTipp();
            gameTipp.setToken(tippDto.getToken());
            gameTipp.setGame(tippDto.getGame());
            gameTipp.setUser(tippDto.getUser());
            gameTipp.setCreationTime(submitTime);
            gameTipp.setLastUpdateTime(submitTime);
            gameTipp.setToken(tippDto.getToken());
            gameTipp.setTipp(GameResult.of(tippDto.getTippDto().getHomeGoals(), tippDto.getTippDto().getGuestGoals()), TippStatusType.USER);
            return gameTipp;
        }
    }
}

