/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.season.dao;

import de.betoffice.storage.hibernate.AbstractCommonDao;
import de.betoffice.storage.season.RoundDao;
import de.betoffice.storage.season.entity.Game;
import de.betoffice.storage.season.entity.GameList;
import de.betoffice.storage.season.entity.Group;
import de.betoffice.storage.season.entity.Season;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository(value="roundDao")
public class RoundDaoHibernate
extends AbstractCommonDao<GameList>
implements RoundDao {
    private static final String QUERY_GAMELIST_BY_SEASON = "select\n    gl\nfrom\n    GameList gl\nwhere\n    gl.season.id = :seasonId\norder by\n    gl.index\n";
    private static final String QUERY_LAST_GAMELIST_BY_SEASON = "select\n    gl\nfrom\n    GameList gl\nwhere\n    gl.season.id = :seasonId\n    and gl.index =\n    (\n        select\n            max(index)\n        from\n            GameList gl2\n        where\n            gl2.season.id = gl.season.id\n    )\n";
    private static final String QUERY_FIRST_GAMELIST_BY_SEASON = "select\n\tgl\nfrom\n      \tGameList gl\n      where\n\tgl.season.id = :seasonId\n    and gl.index =\n    (\n\t\tselect\n      \t\tmin(index)\n    \tfrom\n      \t\tGameList gl2\n      \twhere\n      \t\tgl2.season.id = gl.season.id\n    )\n";
    private static final String QUERY_GAMELIST_AND_GAMES_BY_SEASON_GROUP = "select distinct round from     GameList as round     left join fetch round.gameList game where     game.group.id = :groupId order    by round.index";
    private static final String QUERY_GAMELIST_OF_GAME = "select round from     GameList as round     join round.gameList game where      game.id = :gameId";
    private static final String QUERY_ROUND_AND_GAMES_BY_INDEX = "select round from     GameList as round     left join fetch round.gameList game     left join fetch game.homeTeam     left join fetch game.guestTeam     left join fetch game.group where     round.season.id = :seasonId     and round.index = :index";
    private static final String QUERY_ROUND_AND_GAMES_BY_ID = "select round from     GameList as round     left join fetch round.gameList game     left join fetch game.homeTeam     left join fetch game.guestTeam     left join fetch game.group where     round.id = :roundId";
    private static final String QUERY_NEXT_ROUND_BY_DATE = "select\n    gl.bo_datetime datetime,\n    gl.id last_round_id\nfrom\n    bo_gamelist gl\nwhere\n    gl.bo_datetime =\n    (\n        select\n            min(t.bo_datetime) datetime\n        from\n        (\n            select\n                r.bo_datetime,\n                r.id\n            from\n                bo_gamelist r,\n                bo_game m\n            where\n                r.id = m.bo_gamelist_ref\n                and m.bo_datetime >= :date\n        ) as t\n    )\n";
    private static final String QUERY_NEXT_GAME_BY_SEASON_AND_DATE = "select\n    gl.bo_datetime round_datetime,\n    gl.id          last_round_id,\n    g.bo_datetime  game_datetime\nfrom\n    bo_gamelist gl\n    join bo_game g on (g.bo_gamelist_ref = gl.id)\nwhere\n    gl.bo_season_ref = :season_id\n    and g.bo_datetime =\n    (\n        select\n            min(g2.bo_datetime)\n        from\n            bo_game g2\n        where\n            g2.bo_datetime > :date\n    )\n";
    private static final String QUERY_NEXT_GAME_BY_SEASON = "select\n    gl.bo_datetime round_datetime,\n    gl.id          last_round_id,\n    g.bo_datetime  game_datetime\nfrom\n    bo_gamelist gl\n    join bo_game g on (g.bo_gamelist_ref = gl.id)\nwhere\n    g.bo_datetime =\n    (\n        select\n            min(g2.bo_datetime)\n        from\n            bo_game g2\n        where\n            g2.bo_datetime > :date\n    )\n";
    private static final String QUERY_MIN_GAME_BY_DATE = "select\n    min(g2.bo_datetime)\nfrom\n    bo_game g2\nwhere\n    g2.bo_datetime > :date\n";
    private static final String QUERY_GAME_BY_DATE = "select\n    g\nfrom\n    Game g\nwhere\n    g.dateTime = :date\n";
    private static final String QUERY_LAST_ROUND_BY_DATE = "select gl.bo_datetime datetime, gl.id last_round_id from bo_gamelist gl where gl.bo_datetime = (    select         max(t.bo_datetime)    from     (        select             r.bo_datetime, r.id        from             bo_gamelist r, bo_game m        where             r.bo_season_ref = :season_id            and r.id = m.bo_gamelist_ref             and m.bo_datetime < :date    ) as t)";
    private static final String QUERY_NEXT_ROUND = AbstractCommonDao.loadQuery(RoundDaoHibernate.class, "query_next_round.sql");
    private static final String QUERY_PREV_ROUND = AbstractCommonDao.loadQuery(RoundDaoHibernate.class, "query_prev_round.sql");

    public RoundDaoHibernate() {
        super(GameList.class);
    }

    @Override
    public List<GameList> findRounds(Season season) {
        List objects = this.getEntityManager().createQuery(QUERY_GAMELIST_BY_SEASON, GameList.class).setParameter("seasonId", (Object)season.getId()).getResultList();
        return objects;
    }

    @Override
    public List<GameList> findRounds(Group group) {
        List objects = this.getEntityManager().createQuery(QUERY_GAMELIST_AND_GAMES_BY_SEASON_GROUP, GameList.class).setParameter("groupId", (Object)group.getId()).getResultList();
        return objects;
    }

    @Override
    public Optional<GameList> findRound(Season season, int index) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_ROUND_AND_GAMES_BY_INDEX, GameList.class).setParameter("seasonId", (Object)season.getId()).setParameter("index", (Object)index);
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<GameList> findRound(long roundId) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_ROUND_AND_GAMES_BY_ID, GameList.class).setParameter("roundId", (Object)roundId);
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<GameList> findRoundByGame(Game game) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_GAMELIST_OF_GAME, GameList.class).setParameter("gameId", (Object)game.getId());
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<Long> findNextTippRound(ZonedDateTime date) {
        NativeQuery query = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_NEXT_ROUND_BY_DATE, Object.class);
        query.setParameter("date", (Object)date, ZonedDateTime.class);
        return this.findNextTippRound((Query)query);
    }

    @Override
    public Optional<Long> findNextTippRound(long seasonId, ZonedDateTime date) {
        NativeQuery query = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_NEXT_GAME_BY_SEASON_AND_DATE, Object.class);
        query.setParameter("season_id", (Object)seasonId);
        query.setParameter("date", (Object)date, ZonedDateTime.class);
        return this.findNextTippRound((Query)query);
    }

    private Optional<Long> findNextTippRound(Query query) {
        try {
            List resultList = query.getResultList();
            if (resultList.size() == 0) {
                return Optional.empty();
            }
            Object[] object = (Object[])resultList.get(0);
            Long roundId = (Long)object[1];
            if (roundId == null) {
                return Optional.empty();
            }
            return Optional.of(Long.valueOf(roundId));
        }
        catch (NonUniqueResultException ex) {
            System.out.println("Mehr als ein Ergebnis gefunden!");
            return Optional.empty();
        }
        catch (NoResultException ex) {
            System.out.println("Kein Ergebnis gefunden!");
            return Optional.empty();
        }
    }

    @Override
    public ZonedDateTime findNearestGame(ZonedDateTime date) {
        NativeQuery query = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_MIN_GAME_BY_DATE, ZonedDateTime.class);
        query.setParameter("date", (Object)date, ZonedDateTime.class);
        return (ZonedDateTime)query.getSingleResult();
    }

    @Override
    public List<Game> findGames(ZonedDateTime date) {
        org.hibernate.query.Query query = ((Session)this.getEntityManager().unwrap(Session.class)).createQuery(QUERY_GAME_BY_DATE, Game.class);
        query.setParameter("date", (Object)date, ZonedDateTime.class);
        return query.getResultList();
    }

    @Override
    public Optional<Long> findLastTippRound(long seasonId, ZonedDateTime date) {
        NativeQuery query = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_LAST_ROUND_BY_DATE);
        query.setParameter("season_id", (Object)seasonId);
        query.setParameter("date", (Object)date, ZonedDateTime.class);
        Optional<Long> result = Optional.empty();
        try {
            Object[] object = (Object[])query.getSingleResult();
            Long roundId = (Long)object[1];
            if (roundId != null) {
                result = Optional.of(Long.valueOf(roundId));
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Optional<Long> findNext(long id) {
        NativeQuery query = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_NEXT_ROUND);
        query.setParameter("roundId", (Object)id);
        query.addScalar("next_round_id");
        Number uniqueResult = (Number)query.uniqueResult();
        Optional<Long> nextRoundId = Optional.empty();
        if (uniqueResult != null) {
            nextRoundId = Optional.of(uniqueResult.longValue());
        }
        return nextRoundId;
    }

    @Override
    public Optional<Long> findPrevious(long id) {
        NativeQuery query = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_PREV_ROUND);
        query.setParameter("roundId", (Object)id);
        query.addScalar("prev_round_id");
        Number uniqueResult = (Number)query.uniqueResult();
        Optional<Long> prevRoundId = Optional.empty();
        if (uniqueResult != null) {
            prevRoundId = Optional.of(uniqueResult.longValue());
        }
        return prevRoundId;
    }

    @Override
    public Optional<GameList> findLastRound(Season season) {
        org.hibernate.query.Query query = ((Session)this.getEntityManager().unwrap(Session.class)).createQuery(QUERY_LAST_GAMELIST_BY_SEASON, GameList.class).setParameter("seasonId", (Object)season.getId());
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<GameList> findFirstRound(Season season) {
        org.hibernate.query.Query query = ((Session)this.getEntityManager().unwrap(Session.class)).createQuery(QUERY_FIRST_GAMELIST_BY_SEASON, GameList.class).setParameter("seasonId", (Object)season.getId());
        return RoundDaoHibernate.singleResult(query);
    }
}

