/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.tip;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class TotoResult
implements Comparable<TotoResult>,
Serializable {
    private static final long serialVersionUID = -674801581469168239L;
    private transient String name;
    private transient int totoValue;
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;
    public static final TotoResult EQUAL = new TotoResult("EQUAL", 2);
    public static final TotoResult TOTO = new TotoResult("TOTO", 1);
    public static final TotoResult ZERO = new TotoResult("ZERO", 0);
    public static final TotoResult UNDEFINED = new TotoResult("UNDEFINED", -1);
    private static final TotoResult[] PRIVATE_VALUES = new TotoResult[]{EQUAL, TOTO, ZERO, UNDEFINED};

    private TotoResult(String name, int totoValue) {
        this.name = name;
        this.totoValue = totoValue;
    }

    public int getIntValue() {
        return this.ordinal;
    }

    @Override
    public int compareTo(TotoResult obj) {
        return this.ordinal - obj.ordinal;
    }

    private Object readResolve() throws ObjectStreamException {
        return PRIVATE_VALUES[this.ordinal];
    }

    public int getTotoValue() {
        return this.totoValue;
    }

    public String toString() {
        return this.name;
    }

    public TotoResult[] toArray() {
        TotoResult[] result = new TotoResult[PRIVATE_VALUES.length];
        System.arraycopy(PRIVATE_VALUES, 0, result, 0, result.length);
        return result;
    }
}

