/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.user;

import de.betoffice.storage.user.entity.User;
import de.betoffice.util.LoggerFactory;
import org.slf4j.Logger;

public class UserResult {
    public static Logger log = LoggerFactory.make();
    public static final long nEqualValue = 13L;
    public static final long nTotoValue = 10L;
    public static final long nZeroValue = 0L;
    private final User user;
    private int totoWin = 0;
    private int win = 0;
    private int ticket = 0;
    private int tabPos = 0;

    public UserResult(User _user) {
        this.user = _user;
    }

    public void setUserWin(int _n) {
        this.win = _n;
    }

    public void setUserTotoWin(int _n) {
        this.totoWin = _n;
    }

    public void setTicket(int _n) {
        this.ticket = _n;
    }

    public void setTabPos(int _n) {
        this.tabPos = _n;
    }

    public void setReset() {
        this.totoWin = 0;
        this.win = 0;
        this.ticket = 0;
        this.tabPos = 0;
    }

    public User getUser() {
        return this.user;
    }

    public int getUserWin() {
        return this.win;
    }

    public int getUserTotoWin() {
        return this.totoWin;
    }

    public int getTicket() {
        return this.ticket;
    }

    public long getPoints() {
        return 13L * (long)this.win + 10L * (long)this.totoWin;
    }

    public int getTippedGames() {
        return this.win + this.totoWin + this.ticket;
    }

    public int getTabPos() {
        return this.tabPos;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[class=UserResult; ");
        buf.append("User: ").append(this.user);
        buf.append(", #10 Pts: ").append(this.getUserTotoWin());
        buf.append(", #13 Pts: ").append(this.getUserWin());
        buf.append(", #Tickets: ").append(this.getTicket());
        buf.append(", SUM(points): ").append(this.getPoints());
        buf.append(", #Tipps: ").append(this.getTippedGames());
        buf.append(", Tabpos: ").append(this.getTabPos());
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return user.getNickname().equals(this.getUser().getNickname());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getUser().getNickname().hashCode();
        return result;
    }
}

