/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.validation;

import de.betoffice.validation.ServiceResult;
import de.betoffice.validation.ValidationMessage;
import de.betoffice.validation.ValidationMessages;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;

class DefaultServiceResult<T>
implements ServiceResult<T> {
    private final T result;
    private final ValidationMessages validationMessages;

    private DefaultServiceResult(T result) {
        this.result = result;
        this.validationMessages = ValidationMessages.empty();
    }

    private DefaultServiceResult(T result, ValidationMessages validationMessages) {
        this.result = result;
        this.validationMessages = validationMessages;
    }

    private DefaultServiceResult(ValidationMessage validationMessage) {
        this.result = null;
        this.validationMessages = ValidationMessages.of(validationMessage);
    }

    private DefaultServiceResult(List<ValidationMessage> validationMessages) {
        this.result = null;
        this.validationMessages = ValidationMessages.of(validationMessages);
    }

    @Override
    public Optional<T> result() {
        return Optional.ofNullable(this.result);
    }

    @Override
    public ValidationMessages messages() {
        return this.validationMessages;
    }

    static <T> ServiceResult<T> sucess(T result) {
        return new DefaultServiceResult<T>(result);
    }

    static <T> ServiceResult<T> failure() {
        return new DefaultServiceResult<T>(ValidationMessage.error());
    }

    static <T> ServiceResult<T> failure(ValidationMessage validationMessage) {
        if (validationMessage.isOk()) {
            throw new IllegalArgumentException("The validationMessage has severity OK, but you want to create a failure.");
        }
        return new DefaultServiceResult<T>(validationMessage);
    }

    static <T> ServiceResult<T> failure(ValidationMessage.MessageType errorType) {
        return new DefaultServiceResult<T>(ValidationMessage.error(errorType));
    }

    static <T> ServiceResult<T> failureWithFormattedError(ValidationMessage.MessageType errorType, Object ... messageParams) {
        return new DefaultServiceResult<T>(ValidationMessage.error(errorType, messageParams));
    }

    @Override
    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.result != null) {
            return this.result;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @Override
    public T orElseThrow() {
        if (this.result != null) {
            return this.result;
        }
        throw new NoSuchElementException("No value present");
    }

    @Override
    public boolean containsAnError() {
        return this.validationMessages.containsAnError();
    }

    @Override
    public boolean isSuccessful() {
        return this.result != null && !this.containsAnError();
    }
}

