/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.hibernate;

import de.awtools.config.PropertiesGlueConfig;
import de.betoffice.database.hibernate.CreateDatabaseSchema;
import de.betoffice.database.hibernate.HibernateProperties;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;

public class HibernateConnectionFactory {
    private Configuration config;
    private HibernateProperties hibernateProperties;

    public HibernateConnectionFactory(List<Class<?>> classes) {
        URL resource = this.getClass().getResource("test-mysql-piratestest.properties");
        PropertiesGlueConfig pc = new PropertiesGlueConfig(resource);
        try {
            pc.load();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.hibernateProperties = new HibernateProperties(pc.getProperties());
        if (!this.hibernateProperties.validate()) {
            throw new IllegalStateException("Hibernate properties are not set!");
        }
        this.config = this.hibernateProperties.createConfiguration(classes);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public HibernateProperties getHibernateProperties() {
        return this.hibernateProperties;
    }

    public Connection createConnection() throws SQLException {
        Connection conn = this.hibernateProperties.createConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    public void createDatabaseSchemaIfCurrentIsNotValid(List<PersistentClass> pcs) {
        CreateDatabaseSchema cds = new CreateDatabaseSchema();
        if (!cds.validateSchema(this.config, pcs)) {
            cds.createSilently(this.config);
        }
    }
}

