/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database;

import de.betoffice.database.commandline.CommandLineArguments;
import de.betoffice.database.commandline.CommandLineParser;
import de.betoffice.database.dbload.ExportDatabase;
import de.betoffice.database.dbload.ImportDatabase;
import de.betoffice.database.schema.CreateMySqlDatabaseAndUsers;
import java.sql.SQLException;

public class Testutils {
    public static void main(String[] args) {
        CommandLineParser clp = new CommandLineParser();
        CommandLineArguments arguments = clp.parse(args, System.out);
        if (arguments != null) {
            switch (arguments.getCommand()) {
                case EXPORT: {
                    ExportDatabase.start(arguments, System.out);
                    break;
                }
                case IMPORT: {
                    ImportDatabase.start(arguments, System.out);
                    break;
                }
                case CREATE_SCHEMA: {
                    try {
                        CreateMySqlDatabaseAndUsers.start(arguments);
                    }
                    catch (SQLException ex) {
                        System.out.println(ex.getLocalizedMessage());
                    }
                    break;
                }
                default: {
                    System.out.println("Unknown command line arguments.");
                }
            }
        }
    }
}

