/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.data;

import de.awtools.basic.LoggerFactory;
import de.betoffice.database.data.DeleteDatabase;
import de.betoffice.database.test.Database;
import de.betoffice.database.test.DatabaseMinusTipp;
import de.betoffice.database.test.Masterdata;
import de.dbload.Dbload;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;

public final class MySqlDatabasedTestSupport {
    private final Logger log = LoggerFactory.make();
    private StopWatch stopWatch = new StopWatch();

    public void setUp(Connection _conn, DataLoader _dataLoader) throws SQLException {
        this.stopWatch.start();
        DeleteDatabase.deleteDatabase(_conn);
        this.stopWatch.stop();
        if (this.log.isInfoEnabled()) {
            this.log.info("Deleting the database: {} ms", (Object)this.stopWatch.getTime());
        }
        if (!_dataLoader.equals((Object)DataLoader.EMPTY)) {
            this.stopWatch.reset();
            this.stopWatch.start();
            Dbload.read((Connection)_conn, _dataLoader.getResource());
            _conn.commit();
            this.stopWatch.stop();
            if (this.log.isInfoEnabled()) {
                this.log.info("Setup the database: {} ms", (Object)this.stopWatch.getTime());
            }
        }
    }

    public static enum DataLoader {
        EMPTY(null),
        FULL(Database.class),
        FULL_WITHOUT_TIPP(DatabaseMinusTipp.class),
        MASTER_DATA(Masterdata.class);

        private final Class<?> datResource;

        private DataLoader(Class<?> resource) {
            this.datResource = resource;
        }

        Class<?> getResource() {
            return this.datResource;
        }
    }
}

