/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.hibernate;

import de.betoffice.database.hibernate.HibernateProperties;
import java.io.File;
import java.io.FileInputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.query.Query;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDatabaseSchema {
    private static final Logger log = LoggerFactory.getLogger(CreateDatabaseSchema.class);

    public void createSilently(Configuration config) {
        SchemaExport schemaExport = new SchemaExport();
        MetadataSources metadata = new MetadataSources((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build());
        schemaExport.setFormat(true);
        schemaExport.create(EnumSet.of(TargetType.DATABASE), metadata.buildMetadata());
    }

    public void create(Configuration config, String outputFile) {
        MetadataSources metadata = new MetadataSources((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build());
        SchemaExport schemaExport = new SchemaExport();
        schemaExport.setFormat(true);
        schemaExport.setOutputFile(outputFile);
        schemaExport.create(EnumSet.of(TargetType.DATABASE), metadata.buildMetadata());
    }

    public boolean validateSchema(Configuration config, List<PersistentClass> clazzes) {
        SessionFactory sessionFactory = config.buildSessionFactory();
        Session session = sessionFactory.openSession();
        boolean checkOk = true;
        for (PersistentClass pc : clazzes) {
            StringBuilder sb = new StringBuilder("from ").append(pc.getClassName());
            log.debug(sb.toString());
            try {
                Query query = session.createQuery(sb.toString());
                query.list();
            }
            catch (HibernateException ex) {
                log.warn("Table " + pc.getTable().getName() + " not found!");
                checkOk = false;
            }
        }
        session.close();
        return checkOk;
    }

    public static void start(File databasePropertiesFile, List<Class<?>> classes, String outputFileName) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(databasePropertiesFile));
        CreateDatabaseSchema script = new CreateDatabaseSchema();
        script.create(HibernateProperties.createConfiguration(properties, classes), outputFileName);
    }
}

