/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.hibernate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;

public class HibernateProperties {
    public static final String DIALECT = "hibernate_dialect";
    public static final String URL = "hibernate_connection_url";
    public static final String DRIVER = "hibernate_connection_driver_class";
    public static final String USERNAME = "hibernate_connection_username";
    public static final String PASSWORD = "hibernate_connection_password";
    private static final String[] KEYS = new String[]{"hibernate_dialect", "hibernate_connection_url", "hibernate_connection_driver_class", "hibernate_connection_username", "hibernate_connection_password"};
    private final Log log = LogFactory.getLog(HibernateProperties.class);
    private final Properties properties;

    public HibernateProperties(Properties _properties) {
        this.properties = _properties;
    }

    public boolean validate() {
        boolean ok = true;
        for (String key : KEYS) {
            if (!StringUtils.isBlank((String)this.properties.getProperty(key))) continue;
            this.log.info((Object)("Hibernate property '" + key + "' not set!"));
            ok = false;
        }
        return ok;
    }

    public Connection createConnection() {
        Connection jdbcConnection = null;
        try {
            Class.forName(this.properties.get(DRIVER).toString());
            jdbcConnection = DriverManager.getConnection(this.properties.getProperty(URL), this.properties.getProperty(USERNAME), this.properties.getProperty(PASSWORD));
        }
        catch (SQLException ex) {
            this.log.error((Object)"connection not created", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            this.log.error((Object)"connection not created", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return jdbcConnection;
    }

    public Configuration createConfiguration(List<Class<?>> classes) {
        Configuration config = new Configuration();
        config.addProperties(this.properties);
        for (Class<?> clazz : classes) {
            config.addClass(clazz);
        }
        return config;
    }

    public static Connection createConnection(Properties properties) {
        HibernateProperties hibernateProperties = new HibernateProperties(properties);
        return hibernateProperties.createConnection();
    }

    public static Configuration createConfiguration(Properties properties, List<Class<?>> classes) {
        HibernateProperties hibernateProperties = new HibernateProperties(properties);
        return hibernateProperties.createConfiguration(classes);
    }
}

