/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.schema;

import de.betoffice.database.commandline.CommandLineArguments;
import de.dbload.jdbc.connector.JdbcConnector;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class CreateMySqlDatabaseAndUsers {
    private static final String DATABASE = "{{database}}";
    private static final String USER = "{{user}}";
    private static final String USER_PASSWORD = "{{userPassword}}";
    private static final String SU = "{{superUser}}";
    private static final String CREATE_DATABASE = "CREATE DATABASE `{{database}}` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci";
    private static final String CREATE_USER_LOCALHOST = "CREATE USER '{{user}}'@'localhost' IDENTIFIED BY '{{userPassword}}'";
    private static final String CREATE_USER_REMOTE = "CREATE USER '{{user}}'@'%' IDENTIFIED BY '{{userPassword}}'";
    private static final String REVOKE_ALL_FROM_USER_LOCAL = "REVOKE ALL PRIVILEGES ON * . * FROM '{{user}}'@'localhost'";
    private static final String REVOKE_ALL_FROM_USER_REMOTE = "REVOKE ALL PRIVILEGES ON * . * FROM '{{user}}'@'%'";
    private static final String GRANT_USER_LOCAL = "GRANT SELECT, INSERT, UPDATE, DELETE ON {{database}}. * TO '{{user}}'@'localhost' WITH GRANT OPTION MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0";
    private static final String GRANT_USER_REMOTE = "GRANT SELECT, INSERT, UPDATE, DELETE ON {{database}}. * TO '{{user}}'@'%' WITH GRANT OPTION  MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0  MAX_USER_CONNECTIONS 0";
    private static final String GRANT_SU_LOCAL = "GRANT SELECT, INSERT, UPDATE, DELETE, CREATE, ALTER, INDEX, DROP, CREATE TEMPORARY TABLES, SHOW VIEW, CREATE ROUTINE, ALTER ROUTINE, EXECUTE, CREATE VIEW, EVENT, TRIGGER, LOCK TABLES ON {{database}}. * TO '{{superUser}}'@'localhost' WITH GRANT OPTION MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0";
    private static final String GRANT_SU_REMOTE = "GRANT SELECT, INSERT, UPDATE, DELETE, CREATE, ALTER, INDEX, DROP, CREATE TEMPORARY TABLES, SHOW VIEW, CREATE ROUTINE, ALTER ROUTINE, EXECUTE, CREATE VIEW, EVENT, TRIGGER, LOCK TABLES ON {{database}}. * TO '{{superUser}}'@'%' WITH GRANT OPTION MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0";

    public static void createSchema(Connection connection, String database, String user, String userPassword, String superUser, String superUserPassword) throws SQLException {
        ArrayList<String> commands = new ArrayList<String>();
        String sqlCreateDatabase = CreateMySqlDatabaseAndUsers.createDatabase(database);
        commands.add(sqlCreateDatabase);
        String sqlCreateUser = CreateMySqlDatabaseAndUsers.createLocalUser(user, userPassword);
        String sqlCreateUserRemote = CreateMySqlDatabaseAndUsers.createRemoteUser(user, userPassword);
        commands.add(sqlCreateUser);
        commands.add(sqlCreateUserRemote);
        String sqlCreateSuLocalhost = CreateMySqlDatabaseAndUsers.createLocalUser(superUser, superUserPassword);
        String sqlCreateSuRemote = CreateMySqlDatabaseAndUsers.createRemoteUser(superUser, superUserPassword);
        commands.add(sqlCreateSuLocalhost);
        commands.add(sqlCreateSuRemote);
        String sqlRevokeAllFromUserLocal = CreateMySqlDatabaseAndUsers.createRevokeAllFromLocalUser(user);
        String sqlRevokeAllFromUserRemote = CreateMySqlDatabaseAndUsers.createRevokeAllFromRemoteUser(user);
        String sqlRevokeAllFromSuLocal = CreateMySqlDatabaseAndUsers.createRevokeAllFromLocalUser(superUser);
        String sqlRevokeAllFromSuRemote = CreateMySqlDatabaseAndUsers.createRevokeAllFromRemoteUser(superUser);
        commands.add(sqlRevokeAllFromUserLocal);
        commands.add(sqlRevokeAllFromUserRemote);
        commands.add(sqlRevokeAllFromSuLocal);
        commands.add(sqlRevokeAllFromSuRemote);
        String sqlGrantUserLocal = CreateMySqlDatabaseAndUsers.createGrantsForUserLocal(database, user);
        String sqlGrantUserRemote = CreateMySqlDatabaseAndUsers.createGrantsForUserRemote(database, user);
        String sqlGrantSuLocal = CreateMySqlDatabaseAndUsers.createGrantsForSuLocal(database, superUser);
        String sqlGrantSuRemote = CreateMySqlDatabaseAndUsers.createGrantsForSuRemote(database, superUser);
        commands.add(sqlGrantUserLocal);
        commands.add(sqlGrantUserRemote);
        commands.add(sqlGrantSuLocal);
        commands.add(sqlGrantSuRemote);
        for (String command : commands) {
            System.out.println(command);
            Statement stmt = connection.createStatement();
            stmt.execute(command);
        }
    }

    public static String createDatabase(String database) {
        return StringUtils.replace((String)CREATE_DATABASE, (String)DATABASE, (String)database);
    }

    public static String createLocalUser(String user, String password) {
        return StringUtils.replace((String)StringUtils.replace((String)CREATE_USER_LOCALHOST, (String)USER, (String)user), (String)USER_PASSWORD, (String)password);
    }

    public static String createRemoteUser(String user, String password) {
        return StringUtils.replace((String)StringUtils.replace((String)CREATE_USER_REMOTE, (String)USER, (String)user), (String)USER_PASSWORD, (String)password);
    }

    public static String createRevokeAllFromLocalUser(String user) {
        return StringUtils.replace((String)REVOKE_ALL_FROM_USER_LOCAL, (String)USER, (String)user);
    }

    public static String createRevokeAllFromRemoteUser(String user) {
        return StringUtils.replace((String)REVOKE_ALL_FROM_USER_REMOTE, (String)USER, (String)user);
    }

    public static String createGrantsForUserLocal(String database, String user) {
        return StringUtils.replace((String)StringUtils.replace((String)GRANT_USER_LOCAL, (String)DATABASE, (String)database), (String)USER, (String)user);
    }

    public static String createGrantsForUserRemote(String database, String user) {
        return StringUtils.replace((String)StringUtils.replace((String)GRANT_USER_REMOTE, (String)DATABASE, (String)database), (String)USER, (String)user);
    }

    public static String createGrantsForSuLocal(String database, String user) {
        return StringUtils.replace((String)StringUtils.replace((String)GRANT_SU_LOCAL, (String)DATABASE, (String)database), (String)SU, (String)user);
    }

    public static String createGrantsForSuRemote(String database, String user) {
        return StringUtils.replace((String)StringUtils.replace((String)GRANT_SU_REMOTE, (String)DATABASE, (String)database), (String)SU, (String)user);
    }

    public static void start(CommandLineArguments edp) throws SQLException {
        Connection connection = JdbcConnector.createConnection((String)edp.getUsername(), (String)edp.getPassword(), (String)edp.getJdbcUrl());
        if (StringUtils.isEmpty((String)edp.getCreateSchemaProperties().getUser())) {
            throw new IllegalArgumentException("The user to create is missing!");
        }
        if (StringUtils.isEmpty((String)edp.getCreateSchemaProperties().getSu())) {
            throw new IllegalArgumentException("The su to create is missing!");
        }
        if (StringUtils.isEmpty((String)edp.getCreateSchemaProperties().getSchema())) {
            throw new IllegalArgumentException("The schema name to create is missing!");
        }
        CreateMySqlDatabaseAndUsers.createSchema(connection, edp.getCreateSchemaProperties().getSchema(), edp.getCreateSchemaProperties().getUser(), edp.getCreateSchemaProperties().getUserPassword(), edp.getCreateSchemaProperties().getSu(), edp.getCreateSchemaProperties().getSuPassword());
    }
}

