/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.data;

import de.betoffice.database.data.DeleteDatabase;
import de.betoffice.database.test.ClasspathResource;
import de.betoffice.database.test.Complete;
import de.betoffice.database.test.CompleteExTipp;
import de.betoffice.database.test.Core;
import de.dbload.Dbload;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseTestData {
    private static final Logger log = LoggerFactory.getLogger(DatabaseTestData.class);
    private final StopWatch stopWatch = new StopWatch();

    public void setUp(Connection conn, DataLoader dataLoader) throws SQLException {
        this.stopWatch.start();
        DeleteDatabase.deleteDatabase(conn);
        this.stopWatch.stop();
        if (log.isInfoEnabled()) {
            log.info("Deleting the database: {} ms", (Object)this.stopWatch.getTime());
        }
        if (!DataLoader.EMPTY.equals((Object)dataLoader)) {
            this.stopWatch.reset();
            this.stopWatch.start();
            Dbload.read((Connection)conn, dataLoader.getResource().getClass(), (String)dataLoader.getResource().name());
            conn.commit();
            this.stopWatch.stop();
            if (log.isInfoEnabled()) {
                log.info("Setup the database: {} ms", (Object)this.stopWatch.getTime());
            }
        }
    }

    public static enum DataLoader {
        EMPTY(null),
        COMPLETE(Complete.instance()),
        COMPLETE_EX_TIPP(CompleteExTipp.instance()),
        CORE(Core.instance());

        private final ClasspathResource classpathResource;

        private DataLoader(ClasspathResource resource) {
            this.classpathResource = resource;
        }

        ClasspathResource getResource() {
            return this.classpathResource;
        }
    }
}

