/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.commandline;

import de.betoffice.database.commandline.CommandLineArguments;
import de.betoffice.database.commandline.CreateSchemaProperties;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineParser {
    public static final String TABLES = "t";
    public static final String FILE = "f";
    public static final String JDBCURL = "d";
    public static final String PASSWORD = "p";
    public static final String USERNAME = "u";
    public static final String HELP = "h";
    public static final String SCHEMANAME = "schema";
    public static final String USER = "user";
    public static final String USER_PASSWORD = "password";
    public static final String SU = "su";
    public static final String SU_PASSWORD = "supassword";
    public static final String COMMAND_EXPORT = "export";
    public static final String COMMAND_IMPORT = "import";
    public static final String COMMAND_CREATE = "createschema";

    private Options parseCommandLine(String[] args) {
        OptionBuilder.withArgName((String)COMMAND_EXPORT);
        OptionBuilder.withDescription((String)"Export some tables of the database.");
        Option exportOption = OptionBuilder.create((String)COMMAND_EXPORT);
        OptionBuilder.withArgName((String)COMMAND_IMPORT);
        OptionBuilder.withDescription((String)"Import some data to the database.");
        Option importOption = OptionBuilder.create((String)COMMAND_IMPORT);
        OptionBuilder.withArgName((String)COMMAND_CREATE);
        OptionBuilder.withDescription((String)"Creates application and administration users with different grants.");
        Option createSchemaOption = OptionBuilder.create((String)COMMAND_CREATE);
        OptionBuilder.withArgName((String)SCHEMANAME);
        OptionBuilder.withDescription((String)"The name of the schema to create.");
        OptionBuilder.hasArg();
        Option createSchema = OptionBuilder.create((String)SCHEMANAME);
        OptionBuilder.withArgName((String)USER);
        OptionBuilder.withDescription((String)"The name of the database user to create.");
        OptionBuilder.hasArg();
        Option userDatabase = OptionBuilder.create((String)USER);
        OptionBuilder.withArgName((String)USER_PASSWORD);
        OptionBuilder.withDescription((String)"The password of the database user to create.");
        OptionBuilder.hasArg();
        Option userPasswordDatabase = OptionBuilder.create((String)USER_PASSWORD);
        OptionBuilder.withArgName((String)SU);
        OptionBuilder.withDescription((String)"The name of the database super user to create.");
        OptionBuilder.hasArg();
        Option suDatabase = OptionBuilder.create((String)SU);
        OptionBuilder.withArgName((String)SU_PASSWORD);
        OptionBuilder.withDescription((String)"The name of the database super user password to create.");
        OptionBuilder.hasArg();
        Option suPasswordDatabase = OptionBuilder.create((String)SU_PASSWORD);
        OptionBuilder.withArgName((String)USERNAME);
        OptionBuilder.withLongOpt((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"User for login.");
        OptionBuilder.isRequired();
        Option username = OptionBuilder.create((String)USERNAME);
        OptionBuilder.withArgName((String)PASSWORD);
        OptionBuilder.withLongOpt((String)USER_PASSWORD);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Password for login");
        OptionBuilder.isRequired((boolean)false);
        Option password = OptionBuilder.create((String)PASSWORD);
        OptionBuilder.withArgName((String)JDBCURL);
        OptionBuilder.withLongOpt((String)"database");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"jdbc database url");
        OptionBuilder.isRequired();
        Option jdbcUrl = OptionBuilder.create((String)JDBCURL);
        OptionBuilder.withArgName((String)FILE);
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the file to wrtite to");
        OptionBuilder.isRequired((boolean)false);
        Option file = OptionBuilder.create((String)FILE);
        OptionBuilder.withArgName((String)TABLES);
        OptionBuilder.withLongOpt((String)"tables");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"the tables to export");
        OptionBuilder.isRequired((boolean)false);
        Option tables = OptionBuilder.create((String)TABLES);
        OptionBuilder.withArgName((String)HELP);
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"print this help");
        Option help = OptionBuilder.create((String)HELP);
        Options options = new Options();
        options.addOption(createSchema);
        options.addOption(userDatabase);
        options.addOption(userPasswordDatabase);
        options.addOption(suDatabase);
        options.addOption(suPasswordDatabase);
        options.addOption(exportOption);
        options.addOption(importOption);
        options.addOption(createSchemaOption);
        options.addOption(username);
        options.addOption(password);
        options.addOption(jdbcUrl);
        options.addOption(file);
        options.addOption(tables);
        options.addOption(help);
        return options;
    }

    public CommandLineArguments parse(String[] args, PrintStream ps) {
        Options options = this.parseCommandLine(args);
        GnuParser parser = new GnuParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (MissingOptionException ex) {
            ps.println(String.format("%s", ex.getMessage()));
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("betoffice database csv export tool", options);
            formatter.printUsage(new PrintWriter(ps), 30, "use me....");
            return null;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        CommandLineArguments edp = null;
        if (commandLine.hasOption(HELP)) {
            this.printHelp(options);
        } else {
            edp = new CommandLineArguments();
            this.setupConnectionProperties(edp, commandLine);
            if (commandLine.hasOption(COMMAND_EXPORT)) {
                edp.setCommand(CommandLineArguments.Command.EXPORT);
            } else if (commandLine.hasOption(COMMAND_IMPORT)) {
                edp.setCommand(CommandLineArguments.Command.IMPORT);
            } else if (commandLine.hasOption(COMMAND_CREATE)) {
                edp.setCommand(CommandLineArguments.Command.CREATE_SCHEMA);
                this.setupCommandLineArgumentsForDatabaseCreate(edp, commandLine);
            } else {
                System.out.println("Missing command parameter.");
                this.printHelp(options);
            }
        }
        return edp;
    }

    private void setupConnectionProperties(CommandLineArguments edp, CommandLine commandLine) {
        edp.setUsername(commandLine.getOptionValue(USERNAME));
        if (commandLine.hasOption(PASSWORD)) {
            edp.setPassword(commandLine.getOptionValue(PASSWORD));
        }
        edp.setJdbcUrl(commandLine.getOptionValue(JDBCURL));
        edp.setFile(commandLine.getOptionValue(FILE));
        edp.setTables(commandLine.getOptionValues(TABLES));
    }

    private void setupCommandLineArgumentsForDatabaseCreate(CommandLineArguments cla, CommandLine commandLine) {
        CreateSchemaProperties csp = new CreateSchemaProperties();
        cla.setCreateSchemaProperties(csp);
        csp.setSchema(commandLine.getOptionValue(SCHEMANAME));
        csp.setUser(commandLine.getOptionValue(USER));
        csp.setUserPassword(commandLine.getOptionValue(USER_PASSWORD));
        csp.setSu(commandLine.getOptionValue(SU));
        csp.setSuPassword(commandLine.getOptionValue(SU_PASSWORD));
    }

    private void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("betoffice database csv import/export tool", options);
    }
}

