/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.hibernate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;

public class HibernateProperties {
    public static final String DIALECT = "betoffice.persistence.dialect";
    public static final String URL = "betoffice.persistence.url";
    public static final String DRIVER = "betoffice.persistence.classname";
    public static final String USERNAME = "betoffice.persistence.username";
    public static final String PASSWORD = "betoffice.persistence.password";
    private static final String[] KEYS = new String[]{"betoffice.persistence.dialect", "betoffice.persistence.url", "betoffice.persistence.classname", "betoffice.persistence.username", "betoffice.persistence.password"};
    private final Log log = LogFactory.getLog(HibernateProperties.class);
    private final Properties properties;

    public HibernateProperties(Properties _properties) {
        this.properties = _properties;
    }

    public boolean validate() {
        boolean ok = true;
        String[] stringArray = KEYS;
        int n = KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (StringUtils.isBlank((CharSequence)this.properties.getProperty(key))) {
                this.log.info((Object)("Hibernate property '" + key + "' not set!"));
                ok = false;
            }
            ++n2;
        }
        return ok;
    }

    public Connection createConnection() {
        Connection jdbcConnection = null;
        try {
            Class.forName(this.properties.get(DRIVER).toString());
            jdbcConnection = DriverManager.getConnection(this.properties.getProperty(URL), this.properties.getProperty(USERNAME), this.properties.getProperty(PASSWORD));
        }
        catch (SQLException ex) {
            this.log.error((Object)"connection not created", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            this.log.error((Object)"connection not created", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return jdbcConnection;
    }

    public Configuration createConfiguration(List<Class<?>> classes) {
        Configuration config = new Configuration();
        config.addProperties(this.properties);
        for (Class<?> clazz : classes) {
            config.addClass(clazz);
        }
        return config;
    }

    public static Connection createConnection(Properties properties) {
        HibernateProperties hibernateProperties = new HibernateProperties(properties);
        return hibernateProperties.createConnection();
    }

    public static Configuration createConfiguration(Properties properties, List<Class<?>> classes) {
        HibernateProperties hibernateProperties = new HibernateProperties(properties);
        return hibernateProperties.createConfiguration(classes);
    }
}

