/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.database.hibernate;

import de.betoffice.database.hibernate.HibernateProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.hibernate.cfg.Configuration;

public class HibernateConnectionFactory {
    private Configuration config;
    private HibernateProperties hibernateProperties;

    public HibernateConnectionFactory(List<Class<?>> classes) {
        URL resource = this.getClass().getResource("test-mysql-piratestest.properties");
        try {
            this.hibernateProperties = new HibernateProperties(this.load(resource));
            if (!this.hibernateProperties.validate()) {
                throw new IllegalStateException("Hibernate properties are not set!");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.config = this.hibernateProperties.createConfiguration(classes);
    }

    private Properties load(URL resource) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = resource.openStream();){
            properties.clear();
            properties.load(is);
        }
        return properties;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public HibernateProperties getHibernateProperties() {
        return this.hibernateProperties;
    }

    public Connection createConnection() throws SQLException {
        Connection conn = this.hibernateProperties.createConnection();
        conn.setAutoCommit(false);
        return conn;
    }
}

