/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.Trie;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class RBBIDataWrapper {
    RBBIDataHeader fHeader;
    short[] fFTable;
    short[] fRTable;
    short[] fSFTable;
    short[] fSRTable;
    CharTrie fTrie;
    String fRuleSource;
    int[] fStatusTable;
    private boolean isBigEndian;
    static final int DATA_FORMAT = 1114794784;
    static final int FORMAT_VERSION = 0x3010000;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    static final int DH_SIZE = 24;
    static final int DH_MAGIC = 0;
    static final int DH_FORMATVERSION = 1;
    static final int DH_LENGTH = 2;
    static final int DH_CATCOUNT = 3;
    static final int DH_FTABLE = 4;
    static final int DH_FTABLELEN = 5;
    static final int DH_RTABLE = 6;
    static final int DH_RTABLELEN = 7;
    static final int DH_SFTABLE = 8;
    static final int DH_SFTABLELEN = 9;
    static final int DH_SRTABLE = 10;
    static final int DH_SRTABLELEN = 11;
    static final int DH_TRIE = 12;
    static final int DH_TRIELEN = 13;
    static final int DH_RULESOURCE = 14;
    static final int DH_RULESOURCELEN = 15;
    static final int DH_STATUSTABLE = 16;
    static final int DH_STATUSTABLELEN = 17;
    static final int ACCEPTING = 0;
    static final int LOOKAHEAD = 1;
    static final int TAGIDX = 2;
    static final int RESERVED = 3;
    static final int NEXTSTATES = 4;
    static final int NUMSTATES = 0;
    static final int ROWLEN = 2;
    static final int FLAGS = 4;
    private static final int ROW_DATA = 8;
    static final int RBBI_LOOKAHEAD_HARD_BREAK = 1;
    static final int RBBI_BOF_REQUIRED = 2;
    static TrieFoldingFunc fTrieFoldingFunc = new TrieFoldingFunc();

    int getRowIndex(int state) {
        return 8 + state * (this.fHeader.fCatCount + 4);
    }

    RBBIDataWrapper() {
    }

    static RBBIDataWrapper get(ByteBuffer bytes) throws IOException {
        int i;
        RBBIDataWrapper This2 = new RBBIDataWrapper();
        ICUBinary.readHeader(bytes, 1114794784, IS_ACCEPTABLE);
        This2.isBigEndian = bytes.order() == ByteOrder.BIG_ENDIAN;
        This2.fHeader = new RBBIDataHeader();
        This2.fHeader.fMagic = bytes.getInt();
        This2.fHeader.fVersion = bytes.getInt(bytes.position());
        This2.fHeader.fFormatVersion[0] = bytes.get();
        This2.fHeader.fFormatVersion[1] = bytes.get();
        This2.fHeader.fFormatVersion[2] = bytes.get();
        This2.fHeader.fFormatVersion[3] = bytes.get();
        This2.fHeader.fLength = bytes.getInt();
        This2.fHeader.fCatCount = bytes.getInt();
        This2.fHeader.fFTable = bytes.getInt();
        This2.fHeader.fFTableLen = bytes.getInt();
        This2.fHeader.fRTable = bytes.getInt();
        This2.fHeader.fRTableLen = bytes.getInt();
        This2.fHeader.fSFTable = bytes.getInt();
        This2.fHeader.fSFTableLen = bytes.getInt();
        This2.fHeader.fSRTable = bytes.getInt();
        This2.fHeader.fSRTableLen = bytes.getInt();
        This2.fHeader.fTrie = bytes.getInt();
        This2.fHeader.fTrieLen = bytes.getInt();
        This2.fHeader.fRuleSource = bytes.getInt();
        This2.fHeader.fRuleSourceLen = bytes.getInt();
        This2.fHeader.fStatusTable = bytes.getInt();
        This2.fHeader.fStatusTableLen = bytes.getInt();
        ICUBinary.skipBytes(bytes, 24);
        if (This2.fHeader.fMagic != 45472 || This2.fHeader.fVersion != 1 && This2.fHeader.fFormatVersion[0] != 3) {
            throw new IOException("Break Iterator Rule Data Magic Number Incorrect, or unsupported data version.");
        }
        int pos = 96;
        if (This2.fHeader.fFTable < pos || This2.fHeader.fFTable > This2.fHeader.fLength) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This2.fHeader.fFTable - pos);
        pos = This2.fHeader.fFTable;
        This2.fFTable = new short[This2.fHeader.fFTableLen / 2];
        for (i = 0; i < This2.fFTable.length; ++i) {
            This2.fFTable[i] = bytes.getShort();
            pos += 2;
        }
        ICUBinary.skipBytes(bytes, This2.fHeader.fRTable - pos);
        pos = This2.fHeader.fRTable;
        This2.fRTable = new short[This2.fHeader.fRTableLen / 2];
        for (i = 0; i < This2.fRTable.length; ++i) {
            This2.fRTable[i] = bytes.getShort();
            pos += 2;
        }
        if (This2.fHeader.fSFTableLen > 0) {
            ICUBinary.skipBytes(bytes, This2.fHeader.fSFTable - pos);
            pos = This2.fHeader.fSFTable;
            This2.fSFTable = new short[This2.fHeader.fSFTableLen / 2];
            for (i = 0; i < This2.fSFTable.length; ++i) {
                This2.fSFTable[i] = bytes.getShort();
                pos += 2;
            }
        }
        if (This2.fHeader.fSRTableLen > 0) {
            ICUBinary.skipBytes(bytes, This2.fHeader.fSRTable - pos);
            pos = This2.fHeader.fSRTable;
            This2.fSRTable = new short[This2.fHeader.fSRTableLen / 2];
            for (i = 0; i < This2.fSRTable.length; ++i) {
                This2.fSRTable[i] = bytes.getShort();
                pos += 2;
            }
        }
        ICUBinary.skipBytes(bytes, This2.fHeader.fTrie - pos);
        pos = This2.fHeader.fTrie;
        bytes.mark();
        This2.fTrie = new CharTrie(bytes, fTrieFoldingFunc);
        bytes.reset();
        if (pos > This2.fHeader.fStatusTable) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This2.fHeader.fStatusTable - pos);
        pos = This2.fHeader.fStatusTable;
        This2.fStatusTable = new int[This2.fHeader.fStatusTableLen / 4];
        for (i = 0; i < This2.fStatusTable.length; ++i) {
            This2.fStatusTable[i] = bytes.getInt();
            pos += 4;
        }
        if (pos > This2.fHeader.fRuleSource) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This2.fHeader.fRuleSource - pos);
        pos = This2.fHeader.fRuleSource;
        StringBuilder sb = new StringBuilder(This2.fHeader.fRuleSourceLen / 2);
        for (i = 0; i < This2.fHeader.fRuleSourceLen; i += 2) {
            sb.append(bytes.getChar());
            pos += 2;
        }
        This2.fRuleSource = sb.toString();
        if (RuleBasedBreakIterator.fDebugEnv != null && RuleBasedBreakIterator.fDebugEnv.indexOf("data") >= 0) {
            This2.dump();
        }
        return This2;
    }

    private int getStateTableNumStates(short[] table) {
        if (this.isBigEndian) {
            return table[0] << 16 | table[1] & 0xFFFF;
        }
        return table[1] << 16 | table[0] & 0xFFFF;
    }

    int getStateTableFlags(short[] table) {
        return table[this.isBigEndian ? 5 : 4];
    }

    void dump() {
        if (this.fFTable.length == 0) {
            throw new NullPointerException();
        }
        System.out.println("RBBI Data Wrapper dump ...");
        System.out.println();
        System.out.println("Forward State Table");
        this.dumpTable(this.fFTable);
        System.out.println("Reverse State Table");
        this.dumpTable(this.fRTable);
        System.out.println("Forward Safe Points Table");
        this.dumpTable(this.fSFTable);
        System.out.println("Reverse Safe Points Table");
        this.dumpTable(this.fSRTable);
        this.dumpCharCategories();
        System.out.println("Source Rules: " + this.fRuleSource);
    }

    public static String intToString(int n, int width) {
        StringBuilder dest = new StringBuilder(width);
        dest.append(n);
        while (dest.length() < width) {
            dest.insert(0, ' ');
        }
        return dest.toString();
    }

    public static String intToHexString(int n, int width) {
        StringBuilder dest = new StringBuilder(width);
        dest.append(Integer.toHexString(n));
        while (dest.length() < width) {
            dest.insert(0, ' ');
        }
        return dest.toString();
    }

    private void dumpTable(short[] table) {
        if (table == null) {
            System.out.println("  -- null -- ");
        } else {
            int n;
            StringBuilder header = new StringBuilder(" Row  Acc Look  Tag");
            for (n = 0; n < this.fHeader.fCatCount; ++n) {
                header.append(RBBIDataWrapper.intToString(n, 5));
            }
            System.out.println(header.toString());
            for (n = 0; n < header.length(); ++n) {
                System.out.print("-");
            }
            System.out.println();
            for (int state = 0; state < this.getStateTableNumStates(table); ++state) {
                this.dumpRow(table, state);
            }
            System.out.println();
        }
    }

    private void dumpRow(short[] table, int state) {
        StringBuilder dest = new StringBuilder(this.fHeader.fCatCount * 5 + 20);
        dest.append(RBBIDataWrapper.intToString(state, 4));
        int row = this.getRowIndex(state);
        if (table[row + 0] != 0) {
            dest.append(RBBIDataWrapper.intToString(table[row + 0], 5));
        } else {
            dest.append("     ");
        }
        if (table[row + 1] != 0) {
            dest.append(RBBIDataWrapper.intToString(table[row + 1], 5));
        } else {
            dest.append("     ");
        }
        dest.append(RBBIDataWrapper.intToString(table[row + 2], 5));
        for (int col = 0; col < this.fHeader.fCatCount; ++col) {
            dest.append(RBBIDataWrapper.intToString(table[row + 4 + col], 5));
        }
        System.out.println(dest);
    }

    private void dumpCharCategories() {
        int category;
        int n = this.fHeader.fCatCount;
        String[] catStrings = new String[n + 1];
        int rangeStart = 0;
        int rangeEnd = 0;
        int lastCat = -1;
        int[] lastNewline = new int[n + 1];
        for (category = 0; category <= this.fHeader.fCatCount; ++category) {
            catStrings[category] = "";
        }
        System.out.println("\nCharacter Categories");
        System.out.println("--------------------");
        for (int char32 = 0; char32 <= 0x10FFFF; ++char32) {
            category = this.fTrie.getCodePointValue(char32);
            if ((category &= 0xFFFFBFFF) < 0 || category > this.fHeader.fCatCount) {
                System.out.println("Error, bad category " + Integer.toHexString(category) + " for char " + Integer.toHexString(char32));
                break;
            }
            if (category == lastCat) {
                rangeEnd = char32;
                continue;
            }
            if (lastCat >= 0) {
                if (catStrings[lastCat].length() > lastNewline[lastCat] + 70) {
                    lastNewline[lastCat] = catStrings[lastCat].length() + 10;
                    int n2 = lastCat;
                    catStrings[n2] = catStrings[n2] + "\n       ";
                }
                int n3 = lastCat;
                catStrings[n3] = catStrings[n3] + " " + Integer.toHexString(rangeStart);
                if (rangeEnd != rangeStart) {
                    int n4 = lastCat;
                    catStrings[n4] = catStrings[n4] + "-" + Integer.toHexString(rangeEnd);
                }
            }
            lastCat = category;
            rangeStart = rangeEnd = char32;
        }
        int n5 = lastCat;
        catStrings[n5] = catStrings[n5] + " " + Integer.toHexString(rangeStart);
        if (rangeEnd != rangeStart) {
            int n6 = lastCat;
            catStrings[n6] = catStrings[n6] + "-" + Integer.toHexString(rangeEnd);
        }
        for (category = 0; category <= this.fHeader.fCatCount; ++category) {
            System.out.println(RBBIDataWrapper.intToString(category, 5) + "  " + catStrings[category]);
        }
        System.out.println();
    }

    static class TrieFoldingFunc
    implements Trie.DataManipulate {
        TrieFoldingFunc() {
        }

        public int getFoldingOffset(int data) {
            if ((data & 0x8000) != 0) {
                return data & Short.MAX_VALUE;
            }
            return 0;
        }
    }

    static final class RBBIDataHeader {
        int fMagic = 0;
        int fVersion;
        byte[] fFormatVersion = new byte[4];
        int fLength;
        int fCatCount;
        int fFTable;
        int fFTableLen;
        int fRTable;
        int fRTableLen;
        int fSFTable;
        int fSFTableLen;
        int fSRTable;
        int fSRTableLen;
        int fTrie;
        int fTrieLen;
        int fRuleSource;
        int fRuleSourceLen;
        int fStatusTable;
        int fStatusTableLen;
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        public boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 3;
        }
    }
}

