/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.wrapper.api;

import de.betoffice.wrapper.api.BetofficeId;
import de.betoffice.wrapper.api.GroupRef;
import de.betoffice.wrapper.api.RoundIndex;
import de.betoffice.wrapper.api.SeasonRef;
import de.betoffice.wrapper.api.TeamRef;
import java.util.Objects;

public class GameRef {
    private final BetofficeId id;
    private final SeasonRef seasonRef;
    private final RoundIndex roundIndex;
    private final GroupRef groupRef;
    private final TeamRef homeTeam;
    private final TeamRef guestTeam;

    private GameRef(BetofficeId id, SeasonRef seasonRef, GroupRef groupRef, RoundIndex roundIndex, TeamRef homeTeam, TeamRef guestTeam) {
        this.id = id;
        this.seasonRef = seasonRef;
        this.groupRef = groupRef;
        this.roundIndex = roundIndex;
        this.homeTeam = homeTeam;
        this.guestTeam = guestTeam;
    }

    public static GameRef of(BetofficeId id, SeasonRef seasonRef, GroupRef groupRef, RoundIndex roundIndex, TeamRef homeTeam, TeamRef guestTeam) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(seasonRef);
        Objects.requireNonNull(roundIndex);
        Objects.requireNonNull(groupRef);
        Objects.requireNonNull(homeTeam);
        Objects.requireNonNull(guestTeam);
        return new GameRef(id, seasonRef, groupRef, roundIndex, homeTeam, guestTeam);
    }

    public BetofficeId betofficeId() {
        return this.id;
    }

    public TeamRef getHomeTeam() {
        return this.homeTeam;
    }

    public TeamRef getGuestTeam() {
        return this.guestTeam;
    }

    public SeasonRef getSeason() {
        return this.seasonRef;
    }

    public GroupRef getGroup() {
        return this.groupRef;
    }

    public RoundIndex getRound() {
        return this.roundIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GameRef gameRef = (GameRef)o;
        return Objects.equals(this.seasonRef, gameRef.seasonRef) && Objects.equals(this.roundIndex, gameRef.roundIndex) && Objects.equals(this.groupRef, gameRef.groupRef) && Objects.equals(this.homeTeam, gameRef.homeTeam) && Objects.equals(this.guestTeam, gameRef.guestTeam);
    }

    public int hashCode() {
        return Objects.hash(this.seasonRef, this.roundIndex, this.groupRef, this.homeTeam, this.guestTeam);
    }
}

