/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.wrapper.api;

import de.betoffice.wrapper.api.GameResult;
import java.util.Objects;

public class Scoring {
    private static final GameResult ZERO_ZERO = GameResult.of(0, 0);
    private final GameResult halfTimeResult;
    private final GameResult result;
    private final GameResult overtimeResult;
    private final GameResult penaltyResult;

    private Scoring(GameResult halfTimeResult, GameResult result, GameResult overtimeResult, GameResult penaltyResult) {
        this.halfTimeResult = halfTimeResult;
        this.result = result;
        this.overtimeResult = overtimeResult;
        this.penaltyResult = penaltyResult;
    }

    public static Scoring of(GameResult halfTimeResult, GameResult result) {
        return new Scoring(halfTimeResult, result, ZERO_ZERO, ZERO_ZERO);
    }

    public static Scoring of(GameResult halfTimeResult, GameResult result, GameResult overtimeResult, GameResult penaltyResult) {
        return new Scoring(halfTimeResult, result, overtimeResult, penaltyResult);
    }

    public GameResult getHalfTimeResult() {
        return this.halfTimeResult;
    }

    public GameResult getResult() {
        return this.result;
    }

    public GameResult getOvertimeResult() {
        return this.overtimeResult;
    }

    public GameResult getPenaltyResult() {
        return this.penaltyResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scoring scoring = (Scoring)o;
        return Objects.equals(this.halfTimeResult, scoring.halfTimeResult) && Objects.equals(this.result, scoring.result) && Objects.equals(this.overtimeResult, scoring.overtimeResult) && Objects.equals(this.penaltyResult, scoring.penaltyResult);
    }

    public int hashCode() {
        return Objects.hash(this.halfTimeResult, this.result, this.overtimeResult, this.penaltyResult);
    }
}

