/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.wrapper.cli;

import de.betoffice.wrapper.cli.ApiCommandLineArguments;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ApiCommandLineParser {
    public Optional<ApiCommandLineArguments> parse(String[] args, PrintStream ps) {
        CommandLine commandLine;
        Options options = this.parseCommandLine(args);
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (MissingOptionException ex) {
            ps.println(String.format("%s", ex.getMessage()));
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Betoffice API command line tool.", options);
            formatter.printUsage(new PrintWriter(ps), 30, "use me....");
            return Optional.empty();
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        ApiCommandLineArguments cla = new ApiCommandLineArguments();
        if (commandLine.hasOption("help")) {
            cla.setCommand(ApiCommandLineArguments.Command.HELP);
        } else if (commandLine.hasOption("test")) {
            cla.setCommand(ApiCommandLineArguments.Command.TEST_DATABASE_CONNECTION);
        }
        return Optional.of(cla);
    }

    private Options parseCommandLine(String[] args) {
        Options options = new Options();
        Option helpOption = Option.builder("help").longOpt("help").desc("print this help").build();
        Option testConnection = Option.builder("test").longOpt("test").desc("Test database connection.").build();
        options.addOption(helpOption);
        options.addOption(testConnection);
        return options;
    }
}

