/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.wrapper.cli;

import de.betoffice.wrapper.api.BetofficeApi;
import de.betoffice.wrapper.api.GroupTypeRef;
import de.betoffice.wrapper.cli.ApiCommandLineArguments;
import de.betoffice.wrapper.cli.ApiCommandLineParser;
import de.betoffice.wrapper.cli.BetofficeApplicationContext;
import java.util.List;
import java.util.Optional;
import org.springframework.context.ApplicationContext;

public class BetofficeApiMain {
    public static void main(String[] args) {
        ApiCommandLineParser parser = new ApiCommandLineParser();
        Optional<ApiCommandLineArguments> acla = parser.parse(args, System.out);
        acla.ifPresent(arguments -> {
            switch (arguments.getCommand()) {
                case HELP: {
                    System.out.println("Help");
                    break;
                }
                case TEST_DATABASE_CONNECTION: {
                    BetofficeApplicationContext bac = new BetofficeApplicationContext();
                    ApplicationContext context = bac.createApplicationContext();
                    BetofficeApi betofficeApi = BetofficeApiMain.getBean(BetofficeApi.class, context);
                    BetofficeApiMain.doit(betofficeApi);
                }
            }
        });
    }

    private static void doit(BetofficeApi betofficeApi) {
        List<GroupTypeRef> result = betofficeApi.groupTypes().result();
        for (GroupTypeRef gtr : result) {
            System.out.println(gtr.groupType());
        }
    }

    public static final <T> T getBean(String beanId, Class<T> requiredType, ApplicationContext context) {
        return context.getBean(beanId, requiredType);
    }

    public static final <T> T getBean(Class<T> requiredType, ApplicationContext context) {
        return context.getBean(requiredType);
    }
}

