/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.wrapper.impl;

import de.betoffice.wrapper.api.ApiResult;
import de.betoffice.wrapper.api.BetofficeApi;
import de.betoffice.wrapper.api.BetofficeId;
import de.betoffice.wrapper.api.GameRef;
import de.betoffice.wrapper.api.GroupRef;
import de.betoffice.wrapper.api.GroupTypeRef;
import de.betoffice.wrapper.api.RoundIndex;
import de.betoffice.wrapper.api.RoundRef;
import de.betoffice.wrapper.api.Scoring;
import de.betoffice.wrapper.api.SeasonRef;
import de.betoffice.wrapper.api.TeamRef;
import de.betoffice.wrapper.impl.TryGetCatcher;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.SeasonReference;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.enums.SeasonType;
import de.winkler.betoffice.storage.enums.TeamType;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultBetofficeApi
implements BetofficeApi {
    private static final ZoneId ZONE_EUROPE_BERLIN = ZoneId.of("Europe/Berlin");
    @Autowired
    private SeasonManagerService seasonManagerService;
    @Autowired
    private MasterDataManagerService masterDataManagerService;

    @Override
    public ApiResult<List<GroupTypeRef>> groupTypes() {
        return TryGetCatcher.tryGetCatch(() -> this.findAllGroupTypes());
    }

    private List<GroupTypeRef> findAllGroupTypes() {
        return this.masterDataManagerService.findAllGroupTypes().stream().map(DefaultBetofficeApi::of).toList();
    }

    private static GroupTypeRef of(GroupType groupType) {
        return GroupTypeRef.of(groupType.getName());
    }

    @Override
    public ApiResult<GroupTypeRef> postGroupType(String groupTypeName) {
        return TryGetCatcher.tryGetCatch(() -> this.buildGroupType(groupTypeName));
    }

    private GroupTypeRef buildGroupType(String groupTypeName) {
        GroupType groupType = new GroupType();
        groupType.setName(groupTypeName);
        this.masterDataManagerService.createGroupType(groupType);
        return GroupTypeRef.of(groupTypeName);
    }

    @Override
    public ApiResult<TeamRef> postTeam(String teamName, String teamLongName, TeamType teamType) {
        return TryGetCatcher.tryGetCatch(() -> this.buildTeam(teamName, teamLongName, teamType));
    }

    private TeamRef buildTeam(String teamName, String teamLongName, TeamType teamType) {
        Team team = Team.TeamBuilder.team(teamName).longName(teamLongName).build();
        this.masterDataManagerService.createTeam(team);
        return TeamRef.of(team.getName());
    }

    @Override
    public ApiResult<SeasonRef> postSeason(String name, String year, SeasonType seasonType, TeamType teamType) {
        return TryGetCatcher.tryGetCatch(() -> this.buildSeason(name, year, seasonType, teamType));
    }

    private SeasonRef buildSeason(String name, String year, SeasonType type, TeamType teamType) {
        Season season = new Season();
        season.setReference(SeasonReference.of(year, name));
        season.setTeamType(teamType);
        season.setMode(type);
        Season season1 = this.seasonManagerService.createSeason(season);
        return SeasonRef.of(season1.getReference().getName(), season1.getReference().getYear());
    }

    @Override
    public ApiResult<SeasonRef> addGroup(SeasonRef seasonRef, GroupTypeRef groupTypeRef) {
        return TryGetCatcher.tryGetCatch(() -> this.buildGroup(seasonRef, groupTypeRef));
    }

    private SeasonRef buildGroup(SeasonRef seasonRef, GroupTypeRef groupTypeRef) {
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeRef.groupType()).orElseThrow(() -> DefaultBetofficeApi.groupTypeRefNotFound(groupTypeRef));
        Season season = this.seasonManagerService.findSeasonByName(seasonRef.name(), seasonRef.year()).orElseThrow(() -> DefaultBetofficeApi.seasonNotFound(seasonRef));
        this.seasonManagerService.addGroupType(season, groupType);
        return seasonRef;
    }

    @Override
    public ApiResult<SeasonRef> addTeam(SeasonRef seasonRef, GroupTypeRef groupTypeRef, TeamRef teamRef) {
        return TryGetCatcher.tryGetCatch(() -> this.buildAddTeam(seasonRef, groupTypeRef, teamRef));
    }

    private SeasonRef buildAddTeam(SeasonRef seasonRef, GroupTypeRef groupTypeRef, TeamRef teamRef) {
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeRef.groupType()).orElseThrow(() -> DefaultBetofficeApi.groupTypeRefNotFound(groupTypeRef));
        Season season = this.seasonManagerService.findSeasonByName(seasonRef.name(), seasonRef.year()).orElseThrow(() -> DefaultBetofficeApi.seasonNotFound(seasonRef));
        Team team = this.masterDataManagerService.findTeam(teamRef.name()).orElseThrow(() -> DefaultBetofficeApi.teamNotFound(teamRef));
        this.seasonManagerService.addTeam(season, groupType, team);
        return seasonRef;
    }

    @Override
    public ApiResult<RoundRef> addRound(SeasonRef seasonRef, GroupTypeRef groupTypeRef, LocalDateTime ldt) {
        return TryGetCatcher.tryGetCatch(() -> this.buildRound(seasonRef, groupTypeRef, this.toZonedDateTime(ldt)));
    }

    @Override
    public ApiResult<RoundRef> addRound(SeasonRef seasonRef, GroupTypeRef groupTypeRef, ZonedDateTime ldt) {
        return TryGetCatcher.tryGetCatch(() -> this.buildRound(seasonRef, groupTypeRef, ldt));
    }

    private RoundRef buildRound(SeasonRef seasonRef, GroupTypeRef groupTypeRef, ZonedDateTime ldt) {
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeRef.groupType()).orElseThrow(() -> DefaultBetofficeApi.groupTypeRefNotFound(groupTypeRef));
        Season season = this.seasonManagerService.findSeasonByName(seasonRef.name(), seasonRef.year()).orElseThrow(() -> DefaultBetofficeApi.seasonNotFound(seasonRef));
        GameList gameList = this.seasonManagerService.addRound(season, ldt, groupType);
        RoundIndex roundIndex = RoundIndex.of(gameList.getIndex() + 1);
        RoundRef roundRef = RoundRef.of(seasonRef, roundIndex, groupTypeRef);
        return roundRef;
    }

    @Override
    public ApiResult<GameRef> putGame(GameRef gameRef, ZonedDateTime zdt) {
        return TryGetCatcher.tryGetCatch(() -> this.buildGame(gameRef, zdt));
    }

    private GameRef buildGame(GameRef gameRef, ZonedDateTime zdt) {
        Game game = this.seasonManagerService.findMatch(gameRef.betofficeId().id());
        game.setDateTime(zdt);
        return gameRef;
    }

    @Override
    public ApiResult<GameRef> postGame(SeasonRef seasonRef, GroupTypeRef groupTypeRef, RoundIndex roundIndex, ZonedDateTime zdt, TeamRef homeTeamRef, TeamRef guestTeamRef) {
        return TryGetCatcher.tryGetCatch(() -> this.buildGame(seasonRef, groupTypeRef, roundIndex, zdt, homeTeamRef, guestTeamRef));
    }

    private GameRef buildGame(SeasonRef seasonRef, GroupTypeRef groupTypeRef, RoundIndex roundIndex, ZonedDateTime zdt, TeamRef homeTeamRef, TeamRef guestTeamRef) {
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeRef.groupType()).orElseThrow(() -> DefaultBetofficeApi.groupTypeRefNotFound(groupTypeRef));
        Season season = this.seasonManagerService.findSeasonByName(seasonRef.name(), seasonRef.year()).orElseThrow(() -> DefaultBetofficeApi.seasonNotFound(seasonRef));
        Group group = this.seasonManagerService.findGroup(season, groupType);
        Team homeTeam = this.masterDataManagerService.findTeam(homeTeamRef.name()).orElseThrow(() -> DefaultBetofficeApi.teamNotFound(homeTeamRef, TeamHomeOrGuest.HOME));
        Team guestTeam = this.masterDataManagerService.findTeam(guestTeamRef.name()).orElseThrow(() -> DefaultBetofficeApi.teamNotFound(guestTeamRef, TeamHomeOrGuest.GUEST));
        RoundRef roundRef = RoundRef.of(seasonRef, roundIndex, groupTypeRef);
        GameList round = this.seasonManagerService.findRound(season, roundIndex.betofficeIndex()).orElseThrow(() -> DefaultBetofficeApi.roundNotFound(roundRef));
        Game game = this.seasonManagerService.addMatch(round, zdt, group, homeTeam, guestTeam);
        return GameRef.of(BetofficeId.of(game.getId()), seasonRef, GroupRef.of(seasonRef, groupTypeRef), roundIndex, homeTeamRef, guestTeamRef);
    }

    @Override
    public ApiResult<GameRef> putGame(GameRef gameRef, Scoring scoring) {
        return TryGetCatcher.tryGetCatch(() -> this.buildResult(gameRef, null, scoring));
    }

    @Override
    public ApiResult<GameRef> putGame(GameRef gameRef, ZonedDateTime zdt, Scoring scoring) {
        return TryGetCatcher.tryGetCatch(() -> this.buildResult(gameRef, zdt, scoring));
    }

    @Override
    public ApiResult<GameRef> putGame(GameRef gameRef, de.betoffice.wrapper.api.GameResult halfTimeResult, de.betoffice.wrapper.api.GameResult result) {
        return TryGetCatcher.tryGetCatch(() -> this.buildResult(gameRef, null, Scoring.of(halfTimeResult, result)));
    }

    private GameRef buildResult(GameRef gameRef, ZonedDateTime zdt, Scoring scoring) {
        Game match = this.seasonManagerService.findMatch(gameRef.betofficeId().id());
        if (match == null) {
            throw new IllegalArgumentException(String.format("game with id='%s' not found", gameRef.betofficeId().id()));
        }
        match.setHalfTimeGoals(DefaultBetofficeApi.toGameResult(scoring.getHalfTimeResult()));
        match.setResult(DefaultBetofficeApi.toGameResult(scoring.getResult()));
        match.setOverTimeGoals(DefaultBetofficeApi.toGameResult(scoring.getOvertimeResult()));
        match.setPenaltyGoals(DefaultBetofficeApi.toGameResult(scoring.getPenaltyResult()));
        match.setPlayed(true);
        if (zdt != null) {
            match.setDateTime(zdt);
        }
        this.seasonManagerService.updateMatch(match);
        return gameRef;
    }

    private static GameResult toGameResult(de.betoffice.wrapper.api.GameResult result) {
        return GameResult.of(result.getHomeGoals(), result.getGuestGoals());
    }

    @Override
    public ZonedDateTime toZonedDateTime(LocalDateTime ldt) {
        return ldt.atZone(ZONE_EUROPE_BERLIN);
    }

    @Override
    public LocalDateTime toDate(String dateTimeAsString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.parse(dateTimeAsString, formatter);
    }

    private static RuntimeException groupTypeRefNotFound(GroupTypeRef groupTypeRef) {
        return new IllegalArgumentException("groupType not found: " + groupTypeRef);
    }

    private static RuntimeException seasonNotFound(SeasonRef seasonRef) {
        return new IllegalArgumentException("season not found: " + seasonRef);
    }

    private static RuntimeException teamNotFound(TeamRef teamRef) {
        return new IllegalArgumentException("team not found: " + teamRef);
    }

    private static RuntimeException teamNotFound(TeamRef teamRef, TeamHomeOrGuest homeOrGuest) {
        switch (homeOrGuest) {
            case HOME: {
                return new IllegalArgumentException("home team not found: " + teamRef);
            }
            case GUEST: {
                new IllegalArgumentException("guest team not found: " + teamRef);
            }
        }
        return new IllegalArgumentException("homeOrGuest type is unknown!");
    }

    private static RuntimeException roundNotFound(RoundRef roundRef) {
        return new IllegalArgumentException("round not found: " + roundRef);
    }

    private static enum TeamHomeOrGuest {
        HOME,
        GUEST;

    }
}

