/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.wrapper.impl;

import de.betoffice.wrapper.api.ApiException;
import de.betoffice.wrapper.api.ApiResult;
import java.util.Objects;

class DefaultOperationResult<T>
implements ApiResult<T> {
    private final ApiException exception;
    private final T result;

    private DefaultOperationResult(T result, ApiException exception) {
        this.result = result;
        this.exception = exception;
    }

    static <T> ApiResult<T> success(T result) {
        Objects.nonNull(result);
        return new DefaultOperationResult<T>(result, null);
    }

    static <T> ApiResult<T> failure(ApiException exception) {
        Objects.nonNull(exception);
        return new DefaultOperationResult<Object>(null, exception);
    }

    @Override
    public T result() {
        return this.result;
    }

    @Override
    public ApiException exeption() {
        return this.exception;
    }

    @Override
    public boolean success() {
        return this.exception == null && this.result != null;
    }

    @Override
    public T orThrow() {
        if (!this.success()) {
            throw this.exception;
        }
        return this.result();
    }
}

