/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GoalDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.Goal;
import java.util.List;
import java.util.Optional;
import org.hibernate.Query;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.stereotype.Repository;

@Repository(value="goalDao")
public class GoalDaoHibernate
extends AbstractCommonDao<Goal>
implements GoalDao {
    public GoalDaoHibernate() {
        super(Goal.class);
    }

    @Override
    public List<Goal> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("from Goal as goal inner join fetch goal.player order by goal.id", Goal.class).getResultList();
    }

    @Override
    public Optional<Goal> findByOpenligaid(long openligaid) {
        Query query2 = this.getSessionFactory().getCurrentSession().createQuery("from Goal as goal where goal.openligaid = :openligaid", Goal.class).setParameter("openligaid", openligaid, StandardBasicTypes.LONG);
        return GoalDaoHibernate.singleResult(query2);
    }

    @Override
    public List<Goal> find(Game match) {
        List<Goal> goals = this.getSessionFactory().getCurrentSession().createQuery("from Goal as goal where goal.game.id = :matchId", Goal.class).setParameter("matchId", match.getId(), StandardBasicTypes.LONG).getResultList();
        return goals;
    }

    @Override
    public void deleteAll(Game game) {
        this.getSessionFactory().getCurrentSession().createSQLQuery("delete from goal g where gaol.game = :game");
    }
}

