/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GroupDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import java.util.List;
import javax.persistence.TypedQuery;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository(value="groupDao")
public class GroupDaoHibernate
extends AbstractCommonDao<Group>
implements GroupDao {
    private static final String QUERY_GROUPS_FROM_SEASON = AbstractCommonDao.loadQuery("hql_groups_season.sql");
    private static final String QUERY_TEAMS_BY_GROUP = AbstractCommonDao.loadQuery("query_teams_group.sql");
    private static final String QUERY_GROUP_BY_SEASON_AND_GROUPTYPE = "select grp  from Group as grp    inner join fetch grp.season as season    inner join fetch grp.groupType as gt    left join fetch grp.teams teams  where    season.id = :seasonId   and gt.id = :groupTypeId";

    public GroupDaoHibernate() {
        super(Group.class);
    }

    @Override
    public List<Group> findAll() {
        List<Group> groups = this.getSessionFactory().getCurrentSession().createQuery("from group").getResultList();
        return groups;
    }

    @Override
    public List<Group> findBySeason(Season season) {
        List<Group> objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GROUPS_FROM_SEASON).setParameter("seasonId", (Object)season.getId()).getResultList();
        return objects;
    }

    @Override
    public List<Team> findTeams(Group group) {
        NativeQuery<Team> query2 = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_TEAMS_BY_GROUP, Team.class);
        query2.setParameter("group_id", (Object)group.getId());
        List<Team> teams = query2.getResultList();
        return teams;
    }

    @Override
    public Group findBySeasonAndGroupType(Season season, GroupType groupType) {
        TypedQuery query2 = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GROUP_BY_SEASON_AND_GROUPTYPE, Group.class);
        query2.setParameter("seasonId", (Object)season.getId());
        query2.setParameter("groupTypeId", (Object)groupType.getId());
        return (Group)query2.getSingleResult();
    }
}

