/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GroupTypeDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import java.util.List;
import java.util.Optional;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository(value="groupTypeDao")
public class GroupTypeDaoHibernate
extends AbstractCommonDao<GroupType>
implements GroupTypeDao {
    private static final String QUERY_GROUPTYPE_BY_NAME = "from " + GroupType.class.getName() + " groupType where groupType.name = :groupTypeName order by groupType.name";
    private static final String QUERY_GROUPTYPES_BY_SEASON = AbstractCommonDao.loadQuery("hql_grouptype_season.sql");

    public GroupTypeDaoHibernate() {
        super(GroupType.class);
    }

    @Override
    public List<GroupType> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("from GroupType order by name", GroupType.class).getResultList();
    }

    @Override
    public Optional<GroupType> findByName(String name) {
        TypedQuery query2 = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GROUPTYPE_BY_NAME, GroupType.class).setParameter("groupTypeName", (Object)name);
        return GroupTypeDaoHibernate.singleResult(query2);
    }

    @Override
    public List<GroupType> findBySeason(Season season) {
        return this.getSessionFactory().getCurrentSession().createQuery(QUERY_GROUPTYPES_BY_SEASON, GroupType.class).setParameter("season_id", (Object)season.getId()).getResultList();
    }
}

