/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.MatchDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Team;
import java.util.List;
import java.util.Optional;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository(value="matchDao")
public class MatchDaoHibernate
extends AbstractCommonDao<Game>
implements MatchDao {
    private static final String QUERY_MATCHES_BY_HOMETEAM = "from " + Game.class.getName() + " as match where match.homeTeam.id = :homeTeamId";
    private static final String QUERY_MATCHES_BY_GUESTTEAM = "from " + Game.class.getName() + " as match where match.guestTeam.id = :guestTeamId";
    private static final String QUERY_MATCHES_BY_HOME_AND_GUEST_TEAM = "select match from " + Game.class.getName() + " as match left join fetch match.goals left join fetch match.location where match.homeTeam.id = :homeTeamId and match.guestTeam.id = :guestTeamId";
    private static final String QUERY_MATCH_BY_HOME_AND_GUEST_TEAM_AND_ROUND = "select     match from     Game as match where     match.homeTeam.id = :homeTeamId and     match.guestTeam.id = :guestTeamId and     match.gameList.id = :gameListId ";

    public MatchDaoHibernate() {
        super(Game.class);
    }

    @Override
    public List<Game> findByHomeTeam(Team homeTeam) {
        List<Game> games = this.getSessionFactory().getCurrentSession().createQuery(QUERY_MATCHES_BY_HOMETEAM).setParameter("homeTeamId", (Object)homeTeam.getId()).getResultList();
        return games;
    }

    @Override
    public List<Game> findByGuestTeam(Team guestTeam) {
        List<Game> games = this.getSessionFactory().getCurrentSession().createQuery(QUERY_MATCHES_BY_GUESTTEAM).setParameter("guestTeamId", (Object)guestTeam.getId()).getResultList();
        return games;
    }

    @Override
    public List<Game> find(Team homeTeam, Team guestTeam) {
        List<Game> games = this.getSessionFactory().getCurrentSession().createQuery(QUERY_MATCHES_BY_HOME_AND_GUEST_TEAM).setParameter("homeTeamId", (Object)homeTeam.getId()).setParameter("guestTeamId", (Object)guestTeam.getId()).getResultList();
        return games;
    }

    @Override
    public List<Game> findAll(Team team1, Team team2) {
        List<Game> objects = this.find(team1, team2);
        objects.addAll(this.find(team2, team1));
        return objects;
    }

    @Override
    public Optional<Game> find(GameList round, Team homeTeam, Team guestTeam) {
        TypedQuery query2 = this.getSessionFactory().getCurrentSession().createQuery(QUERY_MATCH_BY_HOME_AND_GUEST_TEAM_AND_ROUND, Game.class).setParameter("homeTeamId", (Object)homeTeam.getId()).setParameter("guestTeamId", (Object)guestTeam.getId()).setParameter("gameListId", (Object)round.getId());
        return MatchDaoHibernate.singleResult(query2);
    }

    @Override
    public List<Game> find(GameList round) {
        TypedQuery query2 = this.getSessionFactory().getCurrentSession().createQuery("from Game g where g.gameList.id = :roundId", Game.class).setParameter("roundId", (Object)round.getId());
        return query2.getResultList();
    }
}

