/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.User;
import java.util.List;
import java.util.Optional;
import javax.persistence.TypedQuery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="userDao")
public class UserDaoHibernate
extends AbstractCommonDao<User>
implements UserDao {
    private static final String QUERY_USER_BY_NICKNAME = "from " + User.class.getName() + " as user where user.nickname = :nickname";

    public UserDaoHibernate() {
        super(User.class);
    }

    private long countAll() {
        return (Long)this.getSessionFactory().getCurrentSession().createQuery("select count(*) from Community c", Long.class).getSingleResult();
    }

    @Override
    public List<User> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("from User u", User.class).getResultList();
    }

    @Override
    public Page<User> findAll(String nicknameFilter, Pageable pageable) {
        long total = this.countAll();
        String filter = "%" + nicknameFilter + "%";
        List users = pageable.isPaged() ? this.getSessionFactory().getCurrentSession().createQuery("from User u where LOWER(u.nickname) like LOWER(:filter)", User.class).setParameter("filter", (Object)filter).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList() : this.getSessionFactory().getCurrentSession().createQuery("from User u where LOWER(u.nickname) like LOWER(:filter)", User.class).setParameter("filter", (Object)filter).getResultList();
        return new PageImpl<User>(users, pageable, total);
    }

    @Override
    public Optional<User> findByNickname(Nickname nickname) {
        TypedQuery user = this.getSessionFactory().getCurrentSession().createQuery(QUERY_USER_BY_NICKNAME, User.class).setParameter("nickname", (Object)nickname);
        return UserDaoHibernate.singleResult(user);
    }
}

