/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.dao.CommunityDao;
import de.winkler.betoffice.dao.CommunityRankingDao;
import de.winkler.betoffice.service.CommunityCalculatorService;
import de.winkler.betoffice.storage.Community;
import de.winkler.betoffice.storage.CommunityReference;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.SeasonRange;
import de.winkler.betoffice.storage.UserResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="communitySeasonService")
public class DefaultCommunityCalculatorService
implements CommunityCalculatorService {
    @Autowired
    private CommunityDao communityDao;
    @Autowired
    private CommunityRankingDao communityRankingDao;

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateRanking(CommunityReference communityReference, GameList round) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        return this.communityRankingDao.calculateUserRanking(community, round);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateRanking(CommunityReference communityReference) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        return this.communityRankingDao.calculateUserRanking(community);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateRanking(CommunityReference communityReference, SeasonRange seasonRange) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        return this.communityRankingDao.calculateUserRanking(community, seasonRange);
    }
}

