/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.dao.CommunityDao;
import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.CommunityService;
import de.winkler.betoffice.storage.Community;
import de.winkler.betoffice.storage.CommunityFilter;
import de.winkler.betoffice.storage.CommunityReference;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.SeasonReference;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.util.LoggerFactory;
import de.winkler.betoffice.validation.BetofficeServiceResult;
import de.winkler.betoffice.validation.BetofficeValidationException;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="communityService")
public class DefaultCommunityService
extends AbstractManagerService
implements CommunityService {
    private static final Logger LOG = LoggerFactory.make();
    @Autowired
    private CommunityDao communityDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private SeasonDao seasonDao;

    @Override
    public Optional<Community> find(CommunityReference communityReference) {
        return this.communityDao.find(communityReference);
    }

    @Override
    public List<Community> find(String communityName) {
        return this.communityDao.find(communityName);
    }

    @Override
    public Page<Community> findCommunities(CommunityFilter communityFilter, Pageable pageable) {
        return this.communityDao.findAll(communityFilter, pageable);
    }

    @Override
    public Page<User> findUsers(String nicknameFilter, Pageable pageable) {
        return this.userDao.findAll(nicknameFilter, pageable);
    }

    @Override
    public Set<User> findMembers(CommunityReference communityReference) {
        return this.communityDao.findMembers(communityReference).getUsers();
    }

    @Override
    public BetofficeServiceResult<Community> create(CommunityReference communityRef, SeasonReference seasonRef, String communityName, Nickname managerNickname) {
        Optional<Community> definedCommunity = this.communityDao.find(communityRef);
        if (definedCommunity.isPresent()) {
            return BetofficeServiceResult.failure(BetofficeValidationMessage.ErrorType.COMMUNITY_EXISTS);
        }
        Season persistedSeason = this.seasonDao.find(seasonRef).orElseThrow();
        User communityManager = this.userDao.findByNickname(managerNickname).orElseThrow();
        Community community = new Community();
        community.setName(communityName);
        community.setReference(communityRef);
        community.setCommunityManager(communityManager);
        community.setSeason(persistedSeason);
        this.communityDao.save(community);
        return BetofficeServiceResult.sucess(community);
    }

    @Override
    public void delete(CommunityReference reference) {
        Community community = this.communityDao.find(reference).orElseThrow();
        if (this.communityDao.hasMembers(reference)) {
            LOG.warn("Unable to delete community '{}'. The Community has members.", (Object)community);
            throw new IllegalArgumentException("Unable to delete community. The Community has members.");
        }
        this.communityDao.delete(community);
    }

    @Override
    public Community addMember(CommunityReference communityReference, Nickname nickname) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        User user = this.userDao.findByNickname(nickname).orElseThrow();
        community.addMember(user);
        this.communityDao.save(community);
        return community;
    }

    @Override
    public Community addMembers(CommunityReference communityReference, Set<Nickname> nicknames) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        nicknames.stream().map(n -> this.userDao.findByNickname((Nickname)n)).forEach(u -> u.ifPresent(us -> community.addMember((User)us)));
        this.communityDao.save(community);
        return community;
    }

    @Override
    public Community removeMember(CommunityReference reference, Nickname nickname) {
        User user = this.userDao.findByNickname(nickname).orElseThrow();
        Community community = this.communityDao.find(reference).orElseThrow();
        community.removeMember(user);
        this.communityDao.save(community);
        return community;
    }

    @Override
    public Community removeMembers(CommunityReference reference, Set<Nickname> nicknames) {
        nicknames.stream().forEach(nickname -> this.removeMember(reference, (Nickname)nickname));
        return this.communityDao.find(reference).orElseThrow();
    }

    @Override
    public Optional<User> findUser(Nickname nickname) {
        return this.userDao.findByNickname(nickname);
    }

    @Override
    @Transactional
    public User createUser(User user) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (user.getNickname() == null || StringUtils.isBlank(user.getNickname().value())) {
            messages.add(new BetofficeValidationMessage("Nickname ist nicht gesetzt.", "nickName", BetofficeValidationMessage.Severity.ERROR));
        }
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        this.userDao.save(user);
        return user;
    }

    @Override
    @Transactional
    public void deleteUser(Nickname nickname) {
        this.userDao.findByNickname(nickname).ifPresent(u -> this.userDao.delete(u));
    }

    @Override
    @Transactional(readOnly=true)
    public List<User> findAllUsers() {
        return this.userDao.findAll();
    }

    @Override
    @Transactional
    public void updateUser(User user) {
        this.userDao.update(user);
    }

    @Override
    @Transactional
    public User findUser(long userId) {
        return (User)this.userDao.findById(userId);
    }
}

