/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.util.LoggerFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;

@Aspect
public class PerformanceMeasurement {
    private final Logger log = LoggerFactory.make();
    private long startTime;
    private long endTime;

    public void startMeasurement() {
        this.startTime = System.currentTimeMillis();
    }

    public void stopMeasurement() {
        this.endTime = System.currentTimeMillis();
    }

    @Around(value="execution(* de.winkler.betoffice.service.Default*Service.*(..))")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) throws Throwable {
        this.startMeasurement();
        Object retVal = pjp.proceed();
        this.stopMeasurement();
        StringBuilder sb = new StringBuilder("Runtime measurement: ");
        sb.append(pjp.getTarget().getClass()).append("#");
        sb.append(pjp.toShortString());
        sb.append(" (ms): ").append(this.endTime - this.startTime);
        this.log.info(sb.toString());
        return retVal;
    }
}

