/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.RoleType;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

public class SecurityToken {
    private final String token;
    private final User user;
    private final List<RoleType> roleTypes;
    private final ZonedDateTime loginTime;

    public SecurityToken(String _token, User _user, List<RoleType> _roleTypes, ZonedDateTime _loginTime) {
        Objects.nonNull(_token);
        Objects.nonNull(_user);
        Objects.nonNull(_roleTypes);
        Objects.nonNull(_loginTime);
        this.token = _token;
        this.user = _user;
        this.roleTypes = _roleTypes;
        this.loginTime = _loginTime;
    }

    public String getToken() {
        return this.token;
    }

    public User getUser() {
        return this.user;
    }

    public ZonedDateTime getLoginTime() {
        return this.loginTime;
    }

    public List<RoleType> getRoleTypes() {
        return this.roleTypes;
    }

    public boolean hasRole(RoleType roleType) {
        return this.roleTypes.contains((Object)roleType);
    }

    public String toString() {
        return "SecurityToken [token=" + this.token + ", user=" + this.user + ", roleTypes=" + this.roleTypes + ", loginTime=" + this.loginTime + "]";
    }
}

