/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;

@Entity
@Table(name="bo_group")
public class Group
extends AbstractStorageObject {
    private static final long serialVersionUID = 2621079132943084772L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @ManyToOne
    @JoinColumn(name="bo_season_ref")
    private Season season;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="bo_team_group", joinColumns={@JoinColumn(name="bo_group_ref")}, inverseJoinColumns={@JoinColumn(name="bo_team_ref")})
    private Set<Team> teams = new HashSet<Team>();
    @ManyToOne
    @JoinColumn(name="bo_grouptype_ref")
    private GroupType groupType;

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public Season getSeason() {
        return this.season;
    }

    protected void setSeason(Season value) {
        Validate.notNull(value);
        this.season = value;
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    protected void setTeams(Set<Team> value) {
        this.teams = value;
    }

    public void addTeam(Team value) {
        Validate.notNull(value);
        this.teams.add(value);
    }

    public void removeTeam(Team value) {
        Validate.notNull(value);
        this.teams.remove(value);
    }

    public boolean isGroupMember(Team team) {
        return this.teams.contains(team);
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType value) {
        this.groupType = value;
    }

    public boolean isValid() {
        if (this.getGroupType() == null) {
            return false;
        }
        return this.getSeason() != null;
    }

    public String debug() {
        return this.getGroupType().getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Group)) {
            return false;
        }
        Group group = (Group)object;
        return Objects.equals(this.getSeason(), group.getSeason()) && Objects.equals(this.getGroupType(), group.getGroupType());
    }

    public int hashCode() {
        return Objects.hash(this.getGroupType(), this.getSeason());
    }
}

