/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import org.apache.commons.lang3.Validate;

public class TeamResult
implements Comparable<TeamResult> {
    private static final long serialVersionUID = -6690928605407554417L;
    private final Season season;
    private final GroupType groupType;
    private final Team team;
    private int posGoals;
    private int negGoals;
    private int win;
    private int lost;
    private int remis;
    private int tablePosition;

    public TeamResult(Season _season, GroupType _groupType, Team _team) {
        this.season = _season;
        this.groupType = _groupType;
        this.team = _team;
    }

    public Season getSeason() {
        return this.season;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public Team getTeam() {
        return this.team;
    }

    public int getPosGoals() {
        return this.posGoals;
    }

    public void setPosGoals(int posGoals) {
        this.posGoals = posGoals;
    }

    public int getNegGoals() {
        return this.negGoals;
    }

    public void setNegGoals(int negGoals) {
        this.negGoals = negGoals;
    }

    private int getGoalDiff() {
        return this.posGoals - this.negGoals;
    }

    public int getWin() {
        return this.win;
    }

    public void setWin(int win) {
        this.win = win;
    }

    public int getLost() {
        return this.lost;
    }

    public void setLost(int lost) {
        this.lost = lost;
    }

    public int getRemis() {
        return this.remis;
    }

    public void setRemis(int remis) {
        this.remis = remis;
    }

    public int getPoints() {
        return this.getWin() * 3 + this.getRemis() * 1;
    }

    public int getGames() {
        return this.getWin() + this.getRemis() + this.getLost();
    }

    public void setTabPos(int _tablePosition) {
        this.tablePosition = _tablePosition;
    }

    public int getTabPos() {
        return this.tablePosition;
    }

    private String getGoalsToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getPosGoals());
        buf.append(':');
        buf.append(this.getNegGoals());
        return buf.toString();
    }

    public static int isBetterAs(TeamResult team1, TeamResult team2) {
        Validate.notNull(team1, "team1 ist null", new Object[0]);
        Validate.notNull(team2, "team2 ist null", new Object[0]);
        if (team1.getPoints() > team2.getPoints()) {
            return 1;
        }
        if (team1.getPoints() < team2.getPoints()) {
            return -1;
        }
        if (team1.getGoalDiff() > team2.getGoalDiff()) {
            return 1;
        }
        if (team1.getGoalDiff() < team2.getGoalDiff()) {
            return -1;
        }
        if (team1.getPosGoals() > team2.getPosGoals()) {
            return 1;
        }
        if (team1.getPosGoals() < team2.getPosGoals()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(TeamResult obj) {
        return TeamResult.isBetterAs(obj, this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getTeam() == null) {
            buf.append("<null>");
        } else {
            buf.append(this.getTeam().getName());
        }
        buf.append(" GroupType: ");
        buf.append(this.getGroupType().getName());
        buf.append(" Goals:");
        buf.append(this.getGoalsToString());
        buf.append(" Points:");
        buf.append(this.getPoints());
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof TeamResult)) {
            return false;
        }
        TeamResult result = (TeamResult)object;
        return result.getTeam().equals(this.getTeam()) && result.getSeason().equals(this.getSeason()) && result.getGroupType().equals(this.getGroupType()) && result.getPosGoals() == this.getPosGoals() && result.getNegGoals() == this.getNegGoals() && result.getWin() == this.getWin() && result.getRemis() == this.getRemis() && result.getLost() == this.getLost();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getTeam().hashCode();
        result = 37 * result + this.getSeason().hashCode();
        result = 37 * result + this.getGroupType().hashCode();
        result = 37 * result + this.posGoals;
        result = 37 * result + this.negGoals;
        result = 37 * result + this.win;
        result = 37 * result + this.lost;
        result = 37 * result + this.remis;
        return result;
    }
}

