/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.tippengine;

import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResultOfDay;
import de.winkler.betoffice.storage.enums.TippStatusType;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class InfoCenter {
    @Autowired
    private TippService tippService;

    public UserResultOfDay findBestTipp(GameList gamelist, List<User> users) {
        Validate.notNull(gamelist);
        Validate.notNull(users);
        UserResultOfDay max = null;
        for (User user : users) {
            if (user.isExcluded()) continue;
            UserResultOfDay points = this.tippService.getUserPoints(gamelist, user);
            if (max == null) {
                max = points;
                continue;
            }
            if (points.getPoints() <= max.getPoints()) continue;
            max = points;
        }
        return max;
    }

    public UserResultOfDay findWorstTipp(GameList gamelist, List<User> users) {
        Validate.notNull(gamelist);
        Validate.notNull(users);
        UserResultOfDay min = null;
        for (User user : users) {
            UserResultOfDay urod;
            if (user.isExcluded() || !TippStatusType.USER.equals((Object)(urod = this.tippService.getUserPoints(gamelist, user)).getStatus())) continue;
            if (min == null) {
                min = urod;
                continue;
            }
            if (!urod.getIsTipped() || urod.getPoints() >= min.getPoints()) continue;
            min = urod;
        }
        return min;
    }

    public GameResult findMediumTipp(Game game, List<User> users) {
        Validate.notNull(game, "game ist null", new Object[0]);
        int homeGoals = 0;
        int guestGoals = 0;
        int counter = 0;
        List<GameTipp> tipps = this.tippService.findTipps(game);
        for (GameTipp tipp : tipps) {
            if (!TippStatusType.USER.equals((Object)tipp.getStatus())) continue;
            ++counter;
            homeGoals += tipp.getTipp().getHomeGoals();
            guestGoals += tipp.getTipp().getGuestGoals();
        }
        if (counter != 0) {
            return new GameResult(Math.round(homeGoals / counter), Math.round(guestGoals / counter));
        }
        return null;
    }
}

