/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.validation;

public class BetofficeValidationMessage {
    private final String message;
    private final String propertyName;
    private final Severity severity;

    public static BetofficeValidationMessage error(String message, String propertyName) {
        return new BetofficeValidationMessage(message, propertyName, Severity.ERROR);
    }

    public static BetofficeValidationMessage error() {
        return new BetofficeValidationMessage("", "", Severity.ERROR);
    }

    public static BetofficeValidationMessage ok() {
        return new BetofficeValidationMessage("", "", Severity.OK);
    }

    public BetofficeValidationMessage(String _message, String _propertyName, Severity _severity) {
        this.message = _message;
        this.propertyName = _propertyName;
        this.severity = _severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public static enum Severity {
        OK,
        ERROR,
        WARNING,
        INFO;

    }

    public static enum ErrorType {
        NO_ERROR,
        COMMUNITY_EXISTS;

    }
}

