/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.javassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.stackmap.MapMaker;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.Hibernate;
import org.hibernate.bytecode.enhance.internal.javassist.AttributeTypeDescriptor;
import org.hibernate.bytecode.enhance.internal.javassist.EnhancerImpl;
import org.hibernate.bytecode.enhance.internal.javassist.JavassistEnhancementContext;
import org.hibernate.bytecode.enhance.internal.javassist.MethodWriter;
import org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesHelper;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class PersistentAttributesEnhancer
extends EnhancerImpl {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(PersistentAttributesEnhancer.class);

    public PersistentAttributesEnhancer(JavassistEnhancementContext context) {
        super(context);
    }

    public void enhance(CtClass managedCtClass) {
        IdentityHashMap<String, PersistentAttributeAccessMethods> attrDescriptorMap = new IdentityHashMap<String, PersistentAttributeAccessMethods>();
        for (CtField persistentField : this.collectPersistentFields(managedCtClass)) {
            attrDescriptorMap.put(persistentField.getName(), this.enhancePersistentAttribute(managedCtClass, persistentField));
        }
        this.enhanceAttributesAccess(managedCtClass, attrDescriptorMap);
        if (this.enhancementContext.doExtendedEnhancement(managedCtClass)) {
            this.extendedEnhancement(managedCtClass);
        }
    }

    private CtField[] collectPersistentFields(CtClass managedCtClass) {
        ArrayList<CtField> persistentFieldList = new ArrayList<CtField>();
        for (CtField ctField : managedCtClass.getDeclaredFields()) {
            if (ctField.getName().startsWith("$$_hibernate_") || "this$0".equals(ctField.getName()) || Modifier.isStatic(ctField.getModifiers()) || !this.enhancementContext.isPersistentField(ctField)) continue;
            persistentFieldList.add(ctField);
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            persistentFieldList.addAll(this.collectInheritPersistentFields(managedCtClass));
        }
        Object[] orderedFields = this.enhancementContext.order(persistentFieldList.toArray(new CtField[0]));
        log.debugf("Persistent fields for entity %s: %s", (Object)managedCtClass.getName(), (Object)Arrays.toString(orderedFields));
        return orderedFields;
    }

    private Collection<CtField> collectInheritPersistentFields(CtClass managedCtClass) {
        if (managedCtClass == null || Object.class.getName().equals(managedCtClass.getName())) {
            return Collections.emptyList();
        }
        try {
            CtClass managedCtSuperclass = managedCtClass.getSuperclass();
            if (this.enhancementContext.isEntityClass(managedCtSuperclass)) {
                return Collections.emptyList();
            }
            if (!this.enhancementContext.isMappedSuperclassClass(managedCtSuperclass)) {
                return this.collectInheritPersistentFields(managedCtSuperclass);
            }
            log.debugf("Found @MappedSuperclass %s to collectPersistenceFields", (Object)managedCtSuperclass.getName());
            ArrayList<CtField> persistentFieldList = new ArrayList<CtField>();
            for (CtField ctField : managedCtSuperclass.getDeclaredFields()) {
                if (ctField.getName().startsWith("$$_hibernate_") || "this$0".equals(ctField.getName()) || Modifier.isStatic(ctField.getModifiers()) || !this.enhancementContext.isPersistentField(ctField)) continue;
                persistentFieldList.add(ctField);
            }
            persistentFieldList.addAll(this.collectInheritPersistentFields(managedCtSuperclass));
            return persistentFieldList;
        }
        catch (NotFoundException nfe) {
            log.warnf("Could not find the superclass of %s", (Object)managedCtClass);
            return Collections.emptyList();
        }
    }

    private PersistentAttributeAccessMethods enhancePersistentAttribute(CtClass managedCtClass, CtField persistentField) {
        try {
            AttributeTypeDescriptor typeDescriptor = AttributeTypeDescriptor.resolve(managedCtClass, persistentField);
            return new PersistentAttributeAccessMethods(this.generateFieldReader(managedCtClass, persistentField, typeDescriptor), this.generateFieldWriter(managedCtClass, persistentField, typeDescriptor));
        }
        catch (Exception e) {
            String msg = String.format("Unable to enhance persistent attribute [%s:%s]", managedCtClass.getName(), persistentField.getName());
            throw new EnhancementException(msg, e);
        }
    }

    protected CtMethod generateFieldReader(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        String fieldName = persistentField.getName();
        String readerName = "$$_hibernate_read_" + fieldName;
        String writerName = "$$_hibernate_write_" + fieldName;
        CtMethod tmpSuperReader = null;
        CtMethod tmpSuperWriter = null;
        CtMethod reader = null;
        try {
            boolean declared = persistentField.getDeclaringClass().equals(managedCtClass);
            String declaredReadFragment = "this." + fieldName;
            String superReadFragment = "super." + readerName + "()";
            if (!declared) {
                try {
                    persistentField.getDeclaringClass().getDeclaredMethod(readerName);
                    persistentField.getDeclaringClass().getDeclaredMethod(writerName);
                }
                catch (NotFoundException nfe) {
                    tmpSuperReader = MethodWriter.addGetter(persistentField.getDeclaringClass(), persistentField.getName(), readerName);
                    tmpSuperWriter = MethodWriter.addSetter(persistentField.getDeclaringClass(), persistentField.getName(), writerName);
                }
            }
            reader = !this.enhancementContext.hasLazyLoadableAttributes(managedCtClass) || !this.enhancementContext.isLazyLoadable(persistentField) ? MethodWriter.write(managedCtClass, "public %s %s() {  return %s;%n}", persistentField.getType().getName(), readerName, declared ? declaredReadFragment : superReadFragment) : MethodWriter.write(managedCtClass, "public %s %s() {%n%s%n  return %s;%n}", persistentField.getType().getName(), readerName, typeDescriptor.buildReadInterceptionBodyFragment(fieldName), declared ? declaredReadFragment : superReadFragment);
            if (tmpSuperReader != null) {
                persistentField.getDeclaringClass().removeMethod(tmpSuperReader);
            }
            if (tmpSuperWriter != null) {
                persistentField.getDeclaringClass().removeMethod(tmpSuperWriter);
            }
            return reader;
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName);
            throw new EnhancementException(msg, cce);
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName);
            throw new EnhancementException(msg, nfe);
        }
    }

    protected CtMethod generateFieldWriter(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        String fieldName = persistentField.getName();
        String readerName = "$$_hibernate_read_" + fieldName;
        String writerName = "$$_hibernate_write_" + fieldName;
        CtMethod tmpSuperReader = null;
        CtMethod tmpSuperWriter = null;
        try {
            boolean declared = persistentField.getDeclaringClass().equals(managedCtClass);
            String declaredWriteFragment = "this." + fieldName + "=" + fieldName + ";";
            String superWriteFragment = "super." + writerName + "(" + fieldName + ");";
            if (!declared) {
                try {
                    persistentField.getDeclaringClass().getDeclaredMethod(readerName);
                    persistentField.getDeclaringClass().getDeclaredMethod(writerName);
                }
                catch (NotFoundException nfe) {
                    tmpSuperReader = MethodWriter.addGetter(persistentField.getDeclaringClass(), persistentField.getName(), readerName);
                    tmpSuperWriter = MethodWriter.addSetter(persistentField.getDeclaringClass(), persistentField.getName(), writerName);
                }
            }
            CtMethod writer = !this.enhancementContext.hasLazyLoadableAttributes(managedCtClass) || !this.enhancementContext.isLazyLoadable(persistentField) ? MethodWriter.write(managedCtClass, "public void %s(%s %s) {%n  %s%n}", writerName, persistentField.getType().getName(), fieldName, declared ? declaredWriteFragment : superWriteFragment) : MethodWriter.write(managedCtClass, "public void %s(%s %s) {%n%s%n}", writerName, persistentField.getType().getName(), fieldName, typeDescriptor.buildWriteInterceptionBodyFragment(fieldName));
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                if (this.enhancementContext.isCompositeClass(managedCtClass)) {
                    writer.insertBefore(String.format("  if (%1$s != null) { %1$s.callOwner(\"\"); }%n", "$$_hibernate_compositeOwners"));
                } else {
                    writer.insertBefore(typeDescriptor.buildInLineDirtyCheckingBodyFragment(this.enhancementContext, persistentField));
                }
                this.handleCompositeField(managedCtClass, persistentField, writer);
            }
            if (this.enhancementContext.doBiDirectionalAssociationManagement(persistentField)) {
                this.handleBiDirectionalAssociation(managedCtClass, persistentField, writer);
            }
            if (tmpSuperReader != null) {
                persistentField.getDeclaringClass().removeMethod(tmpSuperReader);
            }
            if (tmpSuperWriter != null) {
                persistentField.getDeclaringClass().removeMethod(tmpSuperWriter);
            }
            return writer;
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance entity class [%s] to add field writer method [%s]", managedCtClass.getName(), writerName);
            throw new EnhancementException(msg, cce);
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance entity class [%s] to add field writer method [%s]", managedCtClass.getName(), writerName);
            throw new EnhancementException(msg, nfe);
        }
    }

    private void handleBiDirectionalAssociation(CtClass managedCtClass, CtField persistentField, CtMethod fieldWriter) throws NotFoundException, CannotCompileException {
        CtMethod setter;
        CtMethod getter;
        if (!PersistentAttributesHelper.isPossibleBiDirectionalAssociation(persistentField)) {
            return;
        }
        CtClass targetEntity = PersistentAttributesHelper.getTargetEntityClass(managedCtClass, persistentField);
        if (targetEntity == null) {
            log.infof("Bi-directional association not managed for field [%s#%s]: Could not find target type", (Object)managedCtClass.getName(), (Object)persistentField.getName());
            return;
        }
        String mappedBy = PersistentAttributesHelper.getMappedBy(persistentField, targetEntity, this.enhancementContext);
        if (mappedBy == null || mappedBy.isEmpty()) {
            log.infof("Bi-directional association not managed for field [%s#%s]: Could not find target field in [%s]", (Object)managedCtClass.getName(), (Object)persistentField.getName(), (Object)targetEntity.getName());
            return;
        }
        String mappedByGetterName = "$$_hibernate_read_" + mappedBy;
        String mappedBySetterName = "$$_hibernate_write_" + mappedBy;
        boolean tmpTargetMethods = false;
        try {
            getter = targetEntity.getDeclaredMethod(mappedByGetterName);
            setter = targetEntity.getDeclaredMethod(mappedByGetterName);
        }
        catch (NotFoundException nfe) {
            getter = MethodWriter.addGetter(targetEntity, mappedBy, mappedByGetterName);
            setter = MethodWriter.addSetter(targetEntity, mappedBy, mappedBySetterName);
            tmpTargetMethods = true;
        }
        String currentAssociationLoaded = String.format("%s.isPropertyInitialized(this.%s, \"%s\")", Hibernate.class.getName(), persistentField.getName(), mappedBy);
        String targetElementLoaded = String.format("%s.isPropertyInitialized(target, \"%s\")", Hibernate.class.getName(), mappedBy);
        String newAssociationLoaded = String.format("%s.isPropertyInitialized($1, \"%s\")", Hibernate.class.getName(), mappedBy);
        if (PersistentAttributesHelper.hasAnnotation(persistentField, OneToOne.class)) {
            fieldWriter.insertBefore(String.format("  if (this.%1$s != null && %2$s && $1 != null) { this.%1$s.%3$s(null); }%n", persistentField.getName(), currentAssociationLoaded, mappedBySetterName));
            fieldWriter.insertAfter(String.format("  if ($1 != null && %s && $1.%s() != this) { $1.%s(this); }%n", newAssociationLoaded, mappedByGetterName, mappedBySetterName));
        }
        if (PersistentAttributesHelper.hasAnnotation(persistentField, OneToMany.class)) {
            boolean isMap = PersistentAttributesHelper.isAssignable(persistentField.getType(), Map.class.getName());
            String toArrayMethod = isMap ? "values().toArray()" : "toArray()";
            fieldWriter.insertBefore(String.format("  if (this.%3$s != null && %1$s) {%n    Object[] array = this.%3$s.%2$s;%n    for (int i = 0; i < array.length; i++) {%n      %4$s target = (%4$s) array[i];%n      if ($1 == null || !$1.contains(target)) { target.%5$s(null); }%n    }%n  }%n", currentAssociationLoaded, toArrayMethod, persistentField.getName(), targetEntity.getName(), mappedBySetterName));
            fieldWriter.insertAfter(String.format("  if ($1 != null && %1$s) {%n    Object[] array = $1.%2$s;%n    for (int i = 0; i < array.length; i++) {%n      %4$s target = (%4$s) array[i];%n      if (%3$s && target.%5$s() != this) { target.%6$s(this); }%n    }%n  }%n", newAssociationLoaded, toArrayMethod, targetElementLoaded, targetEntity.getName(), mappedByGetterName, mappedBySetterName));
        }
        if (PersistentAttributesHelper.hasAnnotation(persistentField, ManyToOne.class)) {
            fieldWriter.insertBefore(String.format("  if (this.%2$s != null && %1$s && this.%2$s.%3$s() != null) { this.%2$s.%3$s().remove(this); }%n", currentAssociationLoaded, persistentField.getName(), mappedByGetterName));
            fieldWriter.insertAfter(String.format("  if ($1 != null && %s) {%n    java.util.Collection c = $1.%s();%n    if (c != null && !c.contains(this)) { c.add(this); }%n  }%n", newAssociationLoaded, mappedByGetterName));
        }
        if (PersistentAttributesHelper.hasAnnotation(persistentField, ManyToMany.class)) {
            if (PersistentAttributesHelper.isAssignable(persistentField.getType(), Map.class.getName()) || PersistentAttributesHelper.isAssignable(targetEntity.getField(mappedBy).getType(), Map.class.getName())) {
                log.infof("Bi-directional association not managed for field [%s#%s]: @ManyToMany in java.util.Map attribute not supported ", (Object)managedCtClass.getName(), (Object)persistentField.getName());
                return;
            }
            fieldWriter.insertBefore(String.format("  if (this.%2$s != null && %1$s) {%n    Object[] array = this.%2$s.toArray();%n    for (int i = 0; i < array.length; i++) {%n      %3$s target = (%3$s) array[i];%n      if ($1 == null || !$1.contains(target)) { target.%4$s().remove(this); }%n    }%n  }%n", currentAssociationLoaded, persistentField.getName(), targetEntity.getName(), mappedByGetterName));
            fieldWriter.insertAfter(String.format("  if ($1 != null && %s) {%n    Object[] array = $1.toArray();%n    for (int i = 0; i < array.length; i++) {%n      %s target = (%s) array[i];%n\t   if (%s) {%n        java.util.Collection c = target.%s();%n        if (c != this && c != null) { c.add(this); }%n      }%n    }%n  }%n", newAssociationLoaded, targetEntity.getName(), targetEntity.getName(), targetElementLoaded, mappedByGetterName));
        }
        if (tmpTargetMethods) {
            targetEntity.removeMethod(getter);
            targetEntity.removeMethod(setter);
        }
    }

    private void handleCompositeField(CtClass managedCtClass, CtField persistentField, CtMethod fieldWriter) throws NotFoundException, CannotCompileException {
        if (!this.enhancementContext.isCompositeClass(persistentField.getType()) || !PersistentAttributesHelper.hasAnnotation(persistentField, Embedded.class)) {
            return;
        }
        this.addCompositeOwnerInterface(managedCtClass);
        String readFragment = persistentField.visibleFrom(managedCtClass) ? persistentField.getName() : "super.$$_hibernate_read_" + persistentField.getName() + "()";
        fieldWriter.insertBefore(String.format("if (%1$s != null) { ((%2$s) %1$s).%3$s(\"%4$s\"); }%n", readFragment, CompositeTracker.class.getName(), "$$_hibernate_clearOwner", persistentField.getName()));
        fieldWriter.insertAfter(String.format("if (%1$s != null) { ((%2$s) %1$s).%4$s(\"%6$s\", (%3$s) this); }%n%5$s(\"%6$s\");", readFragment, CompositeTracker.class.getName(), CompositeOwner.class.getName(), "$$_hibernate_setOwner", "$$_hibernate_trackChange", persistentField.getName()));
    }

    private void addCompositeOwnerInterface(CtClass managedCtClass) throws NotFoundException, CannotCompileException {
        CtClass compositeOwnerCtClass = managedCtClass.getClassPool().get(CompositeOwner.class.getName());
        for (CtClass i : managedCtClass.getInterfaces()) {
            if (!i.subclassOf(compositeOwnerCtClass)) continue;
            return;
        }
        managedCtClass.addInterface(compositeOwnerCtClass);
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            MethodWriter.write(managedCtClass, "public void %1$s(String name) {%n  if (%2$s != null) { %2$s.callOwner(\".\" + name); }%n}", "$$_hibernate_trackChange", "$$_hibernate_compositeOwners");
        }
    }

    protected void enhanceAttributesAccess(CtClass managedCtClass, IdentityHashMap<String, PersistentAttributeAccessMethods> attributeDescriptorMap) {
        ConstPool constPool = managedCtClass.getClassFile().getConstPool();
        ClassPool classPool = managedCtClass.getClassPool();
        for (MethodInfo oMethod : managedCtClass.getClassFile().getMethods()) {
            MethodInfo methodInfo = oMethod;
            String methodName = methodInfo.getName();
            if (methodName.startsWith("$$_hibernate_") || methodInfo.getCodeAttribute() == null) continue;
            try {
                CodeIterator itr = methodInfo.getCodeAttribute().iterator();
                while (itr.hasNext()) {
                    int methodIndex;
                    String fieldName;
                    PersistentAttributeAccessMethods attributeMethods;
                    int index = itr.next();
                    int op = itr.byteAt(index);
                    if (op != 181 && op != 180 || !managedCtClass.getName().equals(constPool.getFieldrefClassName(itr.u16bitAt(index + 1))) || (attributeMethods = attributeDescriptorMap.get(fieldName = constPool.getFieldrefName(itr.u16bitAt(index + 1)))) == null) continue;
                    log.debugf("Transforming access to field [%s] from method [%s]", (Object)fieldName, (Object)methodName);
                    if (op == 180) {
                        methodIndex = MethodWriter.addMethod(constPool, attributeMethods.getReader());
                        itr.writeByte(182, index);
                        itr.write16bit(methodIndex, index + 1);
                        continue;
                    }
                    methodIndex = MethodWriter.addMethod(constPool, attributeMethods.getWriter());
                    itr.writeByte(182, index);
                    itr.write16bit(methodIndex, index + 1);
                }
                methodInfo.getCodeAttribute().setAttribute(MapMaker.make(classPool, methodInfo));
            }
            catch (BadBytecode bb) {
                String msg = String.format("Unable to perform field access transformation in method [%s]", methodName);
                throw new EnhancementException(msg, bb);
            }
        }
    }

    public void extendedEnhancement(CtClass aCtClass) {
        ConstPool constPool = aCtClass.getClassFile().getConstPool();
        ClassPool classPool = aCtClass.getClassPool();
        for (MethodInfo oMethod : aCtClass.getClassFile().getMethods()) {
            MethodInfo methodInfo = oMethod;
            String methodName = methodInfo.getName();
            if (methodName.startsWith("$$_hibernate_") || methodInfo.getCodeAttribute() == null) continue;
            try {
                CodeIterator itr = methodInfo.getCodeAttribute().iterator();
                while (itr.hasNext()) {
                    int index = itr.next();
                    int op = itr.byteAt(index);
                    if (op != 181 && op != 180) continue;
                    String fieldName = constPool.getFieldrefName(itr.u16bitAt(index + 1));
                    String fieldClassName = constPool.getClassInfo(constPool.getFieldrefClass(itr.u16bitAt(index + 1)));
                    CtClass targetCtClass = classPool.getCtClass(fieldClassName);
                    if (!this.enhancementContext.isEntityClass(targetCtClass) && !this.enhancementContext.isCompositeClass(targetCtClass) || targetCtClass == aCtClass || !this.enhancementContext.isPersistentField(targetCtClass.getField(fieldName)) || PersistentAttributesHelper.hasAnnotation(targetCtClass, fieldName, Id.class) || "this$0".equals(fieldName)) continue;
                    log.debugf("Extended enhancement: Transforming access to field [%s.%s] from method [%s#%s]", fieldClassName, fieldName, aCtClass.getName(), methodName);
                    if (op == 180) {
                        int fieldReaderMethodIndex = constPool.addMethodrefInfo(constPool.addClassInfo(fieldClassName), "$$_hibernate_read_" + fieldName, "()" + constPool.getFieldrefType(itr.u16bitAt(index + 1)));
                        itr.writeByte(182, index);
                        itr.write16bit(fieldReaderMethodIndex, index + 1);
                        continue;
                    }
                    int fieldWriterMethodIndex = constPool.addMethodrefInfo(constPool.addClassInfo(fieldClassName), "$$_hibernate_write_" + fieldName, "(" + constPool.getFieldrefType(itr.u16bitAt(index + 1)) + ")V");
                    itr.writeByte(182, index);
                    itr.write16bit(fieldWriterMethodIndex, index + 1);
                }
                methodInfo.getCodeAttribute().setAttribute(MapMaker.make(classPool, methodInfo));
            }
            catch (BadBytecode bb) {
                String msg = String.format("Unable to perform extended enhancement in method [%s]", methodName);
                throw new EnhancementException(msg, bb);
            }
            catch (NotFoundException nfe) {
                String msg = String.format("Unable to perform extended enhancement in method [%s]", methodName);
                throw new EnhancementException(msg, nfe);
            }
        }
    }

    private static class PersistentAttributeAccessMethods {
        private final CtMethod reader;
        private final CtMethod writer;

        private PersistentAttributeAccessMethods(CtMethod reader, CtMethod writer) {
            this.reader = reader;
            this.writer = writer;
        }

        private CtMethod getReader() {
            return this.reader;
        }

        private CtMethod getWriter() {
            return this.writer;
        }
    }
}

