/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.util.PrepareResult;

public final class ClientParser
implements PrepareResult {
    private final String sql;
    private final List<byte[]> queryParts;
    private final int paramCount;

    private ClientParser(String sql, List<byte[]> queryParts) {
        this.sql = sql;
        this.queryParts = queryParts;
        this.paramCount = queryParts.size() - 1;
    }

    public static ClientParser parameterParts(String queryString, boolean noBackslashEscapes) {
        ArrayList<byte[]> partList = new ArrayList<byte[]>();
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean endingSemicolon = false;
        boolean singleQuotes = false;
        int lastParameterPosition = 0;
        char[] query2 = queryString.toCharArray();
        int queryLength = query2.length;
        for (int i = 0; i < queryLength; ++i) {
            char car = query2[i];
            if (!(state != LexState.Escape || car == '\'' && singleQuotes || car == '\"' && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case ';': {
                    if (state != LexState.Normal) break;
                    endingSemicolon = true;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    partList.add(queryString.substring(lastParameterPosition, i).getBytes(StandardCharsets.UTF_8));
                    lastParameterPosition = i + 1;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                default: {
                    if (state != LexState.Normal || !endingSemicolon || (byte)car < 40) break;
                    endingSemicolon = false;
                }
            }
            lastChar = car;
        }
        if (lastParameterPosition == 0) {
            partList.add(queryString.getBytes(StandardCharsets.UTF_8));
        } else {
            partList.add(queryString.substring(lastParameterPosition, queryLength).getBytes(StandardCharsets.UTF_8));
        }
        return new ClientParser(queryString, partList);
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public List<byte[]> getQueryParts() {
        return this.queryParts;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick;

    }
}

