/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final DeclaredQuery query;
    private final DeclaredQuery countQuery;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final SpelExpressionParser parser;
    private final QueryParameterSetter.QueryMetadataCache metadataCache = new QueryParameterSetter.QueryMetadataCache();

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, QueryMethodEvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em);
        Assert.hasText(queryString, "Query string must not be null or empty!");
        Assert.notNull((Object)evaluationContextProvider, "ExpressionEvaluationContextProvider must not be null!");
        Assert.notNull((Object)parser, "Parser must not be null!");
        this.evaluationContextProvider = evaluationContextProvider;
        this.query = new ExpressionBasedStringQuery(queryString, (JpaEntityMetadata<?>)method.getEntityInformation(), parser);
        DeclaredQuery countQuery = this.query.deriveCountQuery(method.getCountQuery(), method.getCountQueryProjection());
        this.countQuery = ExpressionBasedStringQuery.from(countQuery, (JpaEntityMetadata)method.getEntityInformation(), parser);
        this.parser = parser;
        Assert.isTrue(method.isNativeQuery() || !this.query.usesJdbcStyleParameters(), "JDBC style parameters (?) are not supported for JPA queries.");
    }

    @Override
    public Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        String sortedQueryString = QueryUtils.applySorting(this.query.getQueryString(), accessor.getSort(), this.query.getAlias());
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection(accessor);
        Query query2 = this.createJpaQuery(sortedQueryString, processor.getReturnedType());
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(sortedQueryString, query2);
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query2, metadata, accessor);
    }

    @Override
    protected ParameterBinder createBinder() {
        return ParameterBinderFactory.createQueryAwareBinder(this.getQueryMethod().getParameters(), this.query, this.parser, this.evaluationContextProvider);
    }

    @Override
    protected Query doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        String queryString = this.countQuery.getQueryString();
        EntityManager em = this.getEntityManager();
        TypedQuery<Long> query2 = this.getQueryMethod().isNativeQuery() ? em.createNativeQuery(queryString) : em.createQuery(queryString, Long.class);
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(queryString, query2);
        ((ParameterBinder)this.parameterBinder.get()).bind(metadata.withQuery(query2), accessor, QueryParameterSetter.ErrorHandling.LENIENT);
        return query2;
    }

    public DeclaredQuery getQuery() {
        return this.query;
    }

    public DeclaredQuery getCountQuery() {
        return this.countQuery;
    }

    protected Query createJpaQuery(String queryString, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(queryString);
        }
        Class<?> typeToRead = this.getTypeToRead(returnedType);
        return typeToRead == null ? em.createQuery(queryString) : em.createQuery(queryString, typeToRead);
    }
}

