/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import javax.persistence.EntityManager;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StoredProcedureJpaQuery
extends AbstractJpaQuery {
    private final StoredProcedureAttributes procedureAttributes;
    private final boolean useNamedParameters;
    private final QueryParameterSetter.QueryMetadataCache metadataCache = new QueryParameterSetter.QueryMetadataCache();

    StoredProcedureJpaQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        this.procedureAttributes = method.getProcedureAttributes();
        this.useNamedParameters = StoredProcedureJpaQuery.useNamedParameters(method);
    }

    private static boolean useNamedParameters(QueryMethod method) {
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isNamedParameter()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected StoredProcedureQuery createQuery(JpaParametersParameterAccessor accessor) {
        return this.applyHints(this.doCreateQuery(accessor), this.getQueryMethod());
    }

    @Override
    protected StoredProcedureQuery doCreateQuery(JpaParametersParameterAccessor accessor) {
        StoredProcedureQuery storedProcedure = this.createStoredProcedure();
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata("singleton", storedProcedure);
        return ((ParameterBinder)this.parameterBinder.get()).bind(storedProcedure, metadata, accessor);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        throw new UnsupportedOperationException("StoredProcedureQuery does not support count queries!");
    }

    @Nullable
    Object extractOutputValue(StoredProcedureQuery storedProcedureQuery) {
        Assert.notNull((Object)storedProcedureQuery, "StoredProcedureQuery must not be null!");
        if (!this.procedureAttributes.hasReturnValue()) {
            return null;
        }
        HashMap<String, Object> outputValues = new HashMap<String, Object>();
        List<String> parameterNames = this.procedureAttributes.getOutputParameterNames();
        for (int i = 0; i < parameterNames.size(); ++i) {
            String name = parameterNames.get(i);
            outputValues.put(name, this.extractOutputParameter(storedProcedureQuery, i));
        }
        return outputValues.size() == 1 ? outputValues.values().iterator().next() : outputValues;
    }

    private Object extractOutputParameter(StoredProcedureQuery storedProcedureQuery, Integer index) {
        String outputParameterName = this.procedureAttributes.getOutputParameterNames().get(index);
        JpaParameters parameters = this.getQueryMethod().getParameters();
        return this.extractOutputParameterValue(storedProcedureQuery, outputParameterName, index, parameters.getNumberOfParameters());
    }

    private Object extractOutputParameterValue(StoredProcedureQuery storedProcedureQuery, String name, Integer index, int offset) {
        return this.useNamedParameters && StringUtils.hasText(name) ? storedProcedureQuery.getOutputParameterValue(name) : storedProcedureQuery.getOutputParameterValue(offset + index + 1);
    }

    private StoredProcedureQuery createStoredProcedure() {
        return this.procedureAttributes.isNamedStoredProcedure() ? this.newNamedStoredProcedureQuery() : this.newAdhocStoredProcedureQuery();
    }

    private StoredProcedureQuery newNamedStoredProcedureQuery() {
        return this.getEntityManager().createNamedStoredProcedureQuery(this.procedureAttributes.getProcedureName());
    }

    private StoredProcedureQuery newAdhocStoredProcedureQuery() {
        JpaParameters params = this.getQueryMethod().getParameters();
        String procedureName = this.procedureAttributes.getProcedureName();
        StoredProcedureQuery procedureQuery = this.getEntityManager().createStoredProcedureQuery(procedureName);
        for (JpaParameters.JpaParameter param : params) {
            if (!param.isBindable()) continue;
            if (this.useNamedParameters) {
                procedureQuery.registerStoredProcedureParameter(param.getName().orElseThrow(() -> new IllegalArgumentException("For queries with named parameters you need to use provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.")), param.getType(), ParameterMode.IN);
                continue;
            }
            procedureQuery.registerStoredProcedureParameter(param.getIndex() + 1, param.getType(), ParameterMode.IN);
        }
        if (this.procedureAttributes.hasReturnValue()) {
            ParameterMode mode = ParameterMode.OUT;
            IntStream.range(0, this.procedureAttributes.getOutputParameterTypes().size()).forEach(i -> {
                Class<?> outputParameterType = this.procedureAttributes.getOutputParameterTypes().get(i);
                if (this.useNamedParameters) {
                    String outputParameterName = this.procedureAttributes.getOutputParameterNames().get(i);
                    procedureQuery.registerStoredProcedureParameter(outputParameterName, outputParameterType, mode);
                } else {
                    procedureQuery.registerStoredProcedureParameter(params.getNumberOfParameters() + i + 1, outputParameterType, mode);
                }
            });
        }
        return procedureQuery;
    }
}

